/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.model;

import com.abtasty.flagship.model.FlagMetadata;
import com.abtasty.flagship.visitor.VisitorDelegate;

public class Flag<T> {
    private final VisitorDelegate visitorDelegate;
    private final String key;
    private final T defaultValue;

    public Flag(VisitorDelegate visitorDelegate, String key, T defaultValue) {
        this.visitorDelegate = visitorDelegate;
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public T value(Boolean userExposed) {
        T value = this.visitorDelegate.getStrategy().getFlagValue(this.key, this.defaultValue);
        if (userExposed.booleanValue()) {
            this.userExposed();
        }
        return value;
    }

    public FlagMetadata metadata() {
        return FlagMetadata.fromModification(this.visitorDelegate.getStrategy().getFlagMetadata(this.key, this.defaultValue));
    }

    public void userExposed() {
        this.visitorDelegate.getStrategy().exposeFlag(this.key, this.defaultValue);
    }

    public boolean exists() {
        return this.metadata().exists();
    }
}

