/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.model;

import com.abtasty.flagship.utils.ETargetingComp;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import java.io.Serializable;
import java.util.HashMap;
import org.json.JSONObject;

public class Targeting
implements Serializable {
    final String key;
    final Object value;
    final String operator;

    public Targeting(String key, Object value, String operator) {
        this.key = key;
        this.value = value;
        this.operator = operator;
    }

    public static Targeting parse(JSONObject jsonObject) {
        try {
            String key = jsonObject.getString("key");
            Object value = jsonObject.get("value");
            String operator = jsonObject.getString("operator");
            return new Targeting(key, value, operator);
        }
        catch (Exception e) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.PARSING, LogManager.Level.ERROR, "an error occurred while parsing  targeting.");
            return null;
        }
    }

    public boolean isTargetingValid(HashMap<String, Object> context) {
        Object contextValue = context.getOrDefault(this.key, null);
        ETargetingComp comparator = ETargetingComp.get(this.operator);
        if (comparator == null || this.key == null) {
            return false;
        }
        if (comparator == ETargetingComp.EQUALS && this.key.equals("fs_all_users")) {
            return true;
        }
        if (contextValue == null) {
            return false;
        }
        return comparator.compare(contextValue, this.value);
    }
}

