/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.model;

import com.abtasty.flagship.model.TargetingList;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;

public class TargetingGroups
implements Serializable {
    private final ArrayList<TargetingList> targetingGroups;

    TargetingGroups(ArrayList<TargetingList> targetingGroups) {
        this.targetingGroups = targetingGroups;
    }

    public static TargetingGroups parse(JSONArray targetingGroupArr) {
        try {
            ArrayList<TargetingList> targetingGroup = new ArrayList<TargetingList>();
            for (int i = 0; i < targetingGroupArr.length(); ++i) {
                TargetingList targetingList = TargetingList.parse(targetingGroupArr.getJSONObject(i));
                if (targetingList == null) continue;
                targetingGroup.add(targetingList);
            }
            return new TargetingGroups(targetingGroup);
        }
        catch (Exception e) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.PARSING, LogManager.Level.ERROR, "an error occurred while parsing  targeting.");
            return null;
        }
    }

    public ArrayList<TargetingList> getTargetingGroups() {
        return this.targetingGroups;
    }

    public Boolean isTargetingValid(HashMap<String, Object> context) {
        if (this.targetingGroups != null) {
            for (TargetingList group : this.targetingGroups) {
                if (!group.isTargetingValid(context).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }
}

