/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.model;

import com.abtasty.flagship.model.Modification;
import com.abtasty.flagship.model.Modifications;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import java.io.Serializable;
import java.util.HashMap;
import org.json.JSONObject;

public class Variation
implements Serializable {
    private final String campaignId;
    private final String variationGroupId;
    private final String variationId;
    private final boolean isReference;
    private final Modifications modifications;
    private int allocation = 100;

    Variation(String campaignId, String variationGroupId, String variationId, boolean isReference, Modifications modifications, int allocation) {
        this.campaignId = campaignId;
        this.variationGroupId = variationGroupId;
        this.variationId = variationId;
        this.isReference = isReference;
        this.modifications = modifications;
        this.allocation = allocation;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getVariationGroupId() {
        return this.variationGroupId;
    }

    public String getVariationId() {
        return this.variationId;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public Modifications getModifications() {
        return this.modifications;
    }

    public HashMap<String, Modification> getModificationsValues() {
        return this.modifications != null ? this.modifications.getValues() : null;
    }

    public int getAllocation() {
        return this.allocation;
    }

    public static Variation parse(Boolean bucketingMode, String campaignId, String campaignType, String slug, String variationGroupId, JSONObject variationObj) {
        try {
            String variationId = variationObj.getString("id");
            boolean isReference = variationObj.optBoolean("reference", false);
            Modifications modifications = Modifications.parse(campaignId, campaignType, slug, variationGroupId, variationId, isReference, variationObj.getJSONObject("modifications"));
            int allocation = variationObj.optInt("allocation", bucketingMode != false ? 0 : 100);
            return new Variation(campaignId, variationGroupId, variationId, isReference, modifications, allocation);
        }
        catch (Exception e) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.PARSING, LogManager.Level.ERROR, "an error occurred while parsing  variation.");
            return null;
        }
    }

    public String toString() {
        return "Variation{campaignId='" + this.campaignId + "', variationGroupId='" + this.variationGroupId + "', variationId='" + this.variationId + "', isReference=" + this.isReference + ", modifications=" + this.modifications + ", allocation=" + this.allocation + "}";
    }
}

