/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.utils;

import com.abtasty.flagship.BuildConfig;
import com.abtasty.flagship.visitor.VisitorDelegate;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class FlagshipContext<T> {
    public static Boolean autoLoading = true;
    private final String name;
    private final String key;
    private boolean reserved = false;
    public static final FlagshipContext<String> DEVICE_LOCALE = new FlagshipContext<String>("DEVICE_LOCALE", "sdk_deviceLanguage"){

        @Override
        public boolean verifyValue(String value) {
            String lang = new Locale(value).getISO3Language();
            return lang != null;
        }
    };
    public static final FlagshipContext<DeviceType> DEVICE_TYPE = new FlagshipContext("DEVICE_TYPE", "sdk_deviceType");
    public static final FlagshipContext<String> DEVICE_MODEL = new FlagshipContext("DEVICE_MODEL", "sdk_deviceModel");
    public static final FlagshipContext<String> LOCATION_CITY = new FlagshipContext("LOCATION_CITY", "sdk_city");
    public static final FlagshipContext<String> LOCATION_REGION = new FlagshipContext("LOCATION_REGION", "sdk_region");
    public static final FlagshipContext<String> LOCATION_COUNTRY = new FlagshipContext("LOCATION_COUNTRY", "sdk_country");
    public static final FlagshipContext<Double> LOCATION_LAT = new FlagshipContext("LOCATION_LAT", "sdk_lat");
    public static final FlagshipContext<Double> LOCATION_LONG = new FlagshipContext("LOCATION_LONG", "sdk_long");
    public static final FlagshipContext<String> IP = new FlagshipContext("IP", "sdk_ip");
    public static final FlagshipContext<String> OS_NAME = new FlagshipContext("OS_NAME", "sdk_osName");
    public static final FlagshipContext<String> OS_VERSION_NAME = new FlagshipContext("OS_VERSION_NAME", "sdk_osVersionName");
    public static final FlagshipContext<Number> OS_VERSION_CODE = new FlagshipContext<Number>("OS_VERSION_CODE", "sdk_osVersionCode"){

        @Override
        public boolean verifyValue(Number value) {
            return value.doubleValue() >= 0.0;
        }
    };
    public static final FlagshipContext<String> CARRIER_NAME = new FlagshipContext("CARRIER_NAME", "sdk_carrierName");
    public static final FlagshipContext<String> INTERNET_CONNECTION = new FlagshipContext("INTERNET_CONNECTION", "sdk_internetConnection");
    public static final FlagshipContext<String> APP_VERSION_NAME = new FlagshipContext("APP_VERSION_NAME", "sdk_versionName");
    public static final FlagshipContext<Number> APP_VERSION_CODE = new FlagshipContext<Number>("APP_VERSION_CODE", "sdk_versionCode"){

        @Override
        public boolean verifyValue(Number value) {
            return value.doubleValue() > 0.0;
        }
    };
    public static final FlagshipContext<String> INTERFACE_NAME = new FlagshipContext("INTERFACE_NAME", "sdk_interfaceName");
    private static final FlagshipContext<String> FLAGSHIP_CLIENT = new FlagshipContext<String>("FLAGSHIP_CLIENT", "fs_client", true){

        @Override
        public String load(VisitorDelegate visitorDelegate) {
            return "java";
        }
    };
    private static final FlagshipContext<String> FLAGSHIP_VERSION = new FlagshipContext<String>("FLAGSHIP_VERSION", "fs_version", true){

        @Override
        public String load(VisitorDelegate visitorDelegate) {
            return BuildConfig.flagship_version_name;
        }
    };
    private static final FlagshipContext<String> FLAGSHIP_VISITOR = new FlagshipContext<String>("FLAGSHIP_VISITOR", "fs_users", true){

        @Override
        public String load(VisitorDelegate visitorDelegate) {
            return visitorDelegate.getVisitorId();
        }
    };
    public static final List<FlagshipContext<?>> ALL = Arrays.asList(DEVICE_LOCALE, DEVICE_TYPE, DEVICE_MODEL, LOCATION_CITY, LOCATION_REGION, LOCATION_COUNTRY, LOCATION_LAT, LOCATION_LONG, IP, OS_NAME, OS_VERSION_NAME, OS_VERSION_CODE, CARRIER_NAME, INTERNET_CONNECTION, APP_VERSION_NAME, APP_VERSION_CODE, INTERFACE_NAME, FLAGSHIP_CLIENT, FLAGSHIP_VERSION, FLAGSHIP_VISITOR);

    private FlagshipContext(String name, String key) {
        this.name = name;
        this.key = key;
    }

    private FlagshipContext(String name, String key, boolean reserved) {
        this.name = name;
        this.key = key;
        this.reserved = reserved;
    }

    public String key() {
        return this.key;
    }

    protected String name() {
        return this.name;
    }

    public static boolean isReserved(String key) {
        return ALL.stream().anyMatch(context -> context.key.equals(key) && context.reserved);
    }

    public final boolean verify(T value) {
        try {
            return value != null && this.verifyValue(value);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean verifyValue(T value) {
        return true;
    }

    public T load(VisitorDelegate visitor) {
        return null;
    }

    public static enum DeviceType {
        MOBILE("mobile"),
        TABLET("tablet"),
        PC("pc"),
        SERVER("server"),
        IOT("iot"),
        OTHER("other");

        String value;

        private DeviceType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

