/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.visitor;

import com.abtasty.flagship.api.HttpManager;
import com.abtasty.flagship.api.TrackingManager;
import com.abtasty.flagship.cache.CacheManager;
import com.abtasty.flagship.cache.HitCacheHelper;
import com.abtasty.flagship.cache.IHitCacheImplementation;
import com.abtasty.flagship.cache.IVisitorCacheImplementation;
import com.abtasty.flagship.cache.VisitorCacheHelper;
import com.abtasty.flagship.decision.DecisionManager;
import com.abtasty.flagship.hits.Activate;
import com.abtasty.flagship.hits.Consent;
import com.abtasty.flagship.hits.Hit;
import com.abtasty.flagship.main.Flagship;
import com.abtasty.flagship.model.Flag;
import com.abtasty.flagship.model.Modification;
import com.abtasty.flagship.utils.FlagshipConstants;
import com.abtasty.flagship.utils.FlagshipContext;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import com.abtasty.flagship.visitor.Visitor;
import com.abtasty.flagship.visitor.VisitorDelegate;
import com.abtasty.flagship.visitor.VisitorDelegateDTO;
import com.abtasty.flagship.visitor.VisitorStrategy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONObject;

class DefaultStrategy
extends VisitorStrategy {
    public DefaultStrategy(VisitorDelegate visitor) {
        super(visitor);
    }

    @Override
    public void updateContext(HashMap<String, Object> context) {
        if (context != null) {
            for (Map.Entry<String, Object> e : context.entrySet()) {
                this.updateContext(e.getKey(), e.getValue());
            }
        }
        this.visitorDelegate.logVisitor(FlagshipLogManager.Tag.UPDATE_CONTEXT);
    }

    @Override
    public <T> void updateContext(String key, T value) {
        if (key == null) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.UPDATE_CONTEXT, LogManager.Level.ERROR, "param 'key' must be a non null String.");
        } else if (!(value instanceof String || value instanceof Number || value instanceof Boolean)) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.UPDATE_CONTEXT, LogManager.Level.ERROR, String.format("'value' for '%s', must be one of the following types : String, Number, Boolean", key));
        } else if (FlagshipContext.isReserved(key)) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.UPDATE_CONTEXT, LogManager.Level.ERROR, String.format("key '%s' is reserved by flagship and can't be modified.", key));
        } else {
            this.visitorDelegate.getContext().put(key, value);
        }
        this.visitorDelegate.logVisitor(FlagshipLogManager.Tag.UPDATE_CONTEXT);
    }

    @Override
    public <T> void updateContext(FlagshipContext<T> flagshipContext, T value) {
        if (flagshipContext.verify(value)) {
            this.visitorDelegate.getContext().put(flagshipContext.key(), value);
        }
    }

    @Override
    public void clearContext() {
        this.visitorDelegate.getContext().clear();
        this.visitorDelegate.loadContext(null);
        this.visitorDelegate.logVisitor(FlagshipLogManager.Tag.UPDATE_CONTEXT);
    }

    @Override
    public void sendContextRequest() {
        TrackingManager trackingManager = this.visitorDelegate.getConfigManager().getTrackingManager();
        trackingManager.sendContextRequest(this.visitorDelegate.toDTO());
    }

    @Override
    public void sendConsentRequest() {
        TrackingManager trackingManager = this.visitorDelegate.getConfigManager().getTrackingManager();
        if (trackingManager != null) {
            trackingManager.sendHit(this.visitorDelegate.toDTO(), new Consent(this.visitorDelegate.getConsent()));
        }
    }

    @Override
    public <T> void sendHit(Hit<T> hit) {
        TrackingManager trackingManager = this.visitorDelegate.getConfigManager().getTrackingManager();
        if (trackingManager != null && hit != null) {
            trackingManager.sendHit(this.visitorDelegate.toDTO(), hit);
        }
    }

    @Override
    public void authenticate(String visitorId) {
        if (this.visitorDelegate.getConfigManager().isDecisionMode(Flagship.DecisionMode.API)) {
            if (this.visitorDelegate.getAnonymousId() == null) {
                this.visitorDelegate.setAnonymousId(this.visitorDelegate.getVisitorId());
            }
            this.visitorDelegate.setVisitorId(visitorId);
        } else {
            FlagshipLogManager.log(FlagshipLogManager.Tag.AUTHENTICATE, LogManager.Level.ERROR, String.format("'%s' method will be ignored in Bucketing configuration.", "authenticate"));
        }
        this.visitorDelegate.loadContext(null);
        this.visitorDelegate.logVisitor(FlagshipLogManager.Tag.AUTHENTICATE);
    }

    @Override
    public void unauthenticate() {
        if (this.visitorDelegate.getConfigManager().isDecisionMode(Flagship.DecisionMode.API)) {
            if (this.visitorDelegate.getAnonymousId() != null) {
                this.visitorDelegate.setVisitorId(this.visitorDelegate.getAnonymousId());
                this.visitorDelegate.setAnonymousId(null);
            }
        } else {
            FlagshipLogManager.log(FlagshipLogManager.Tag.UNAUTHENTICATE, LogManager.Level.ERROR, String.format("'%s' method will be ignored in Bucketing configuration.", "unauthenticate"));
        }
        this.visitorDelegate.loadContext(null);
        this.visitorDelegate.logVisitor(FlagshipLogManager.Tag.UNAUTHENTICATE);
    }

    @Override
    public void setConsent(Boolean hasConsented) {
        this.visitorDelegate.setConsent(hasConsented);
        if (!hasConsented.booleanValue()) {
            this.visitorDelegate.getStrategy().flushVisitorCache();
            this.visitorDelegate.getStrategy().flushHitCache();
        }
        this.sendConsentRequest();
    }

    @Override
    public Boolean hasConsented() {
        return this.visitorDelegate.getConsent();
    }

    @Override
    void loadContext(HashMap<String, Object> context) {
        if (context != null) {
            for (Map.Entry entry : context.entrySet()) {
                this.updateContext((String)entry.getKey(), entry.getValue());
            }
        }
        if (FlagshipContext.autoLoading.booleanValue()) {
            for (FlagshipContext flagshipContext : FlagshipContext.ALL) {
                this.updateContext(flagshipContext, flagshipContext.load(this.visitorDelegate));
            }
        }
    }

    @Override
    public void cacheVisitor() {
        VisitorDelegateDTO visitorDelegateDTO = this.visitorDelegate.toDTO();
        CacheManager cacheManager = this.flagshipConfig.getCacheManager();
        if (cacheManager != null) {
            CompletableFuture.supplyAsync(() -> {
                try {
                    IVisitorCacheImplementation visitorCacheImplementation = this.flagshipConfig.getCacheManager().getVisitorCacheImplementation();
                    if (visitorCacheImplementation != null) {
                        visitorCacheImplementation.cacheVisitor(visitorDelegateDTO.getVisitorId(), VisitorCacheHelper.visitorToCacheJSON(visitorDelegateDTO));
                    }
                }
                catch (Exception e) {
                    this.logCacheException(String.format("Error: '%s' for visitor '%s' threw an exception.", "cacheVisitor", visitorDelegateDTO.getVisitorId()), e);
                }
                return 0;
            });
        }
    }

    @Override
    public void lookupVisitorCache() {
        VisitorDelegateDTO visitorDelegateDTO = this.visitorDelegate.toDTO();
        CacheManager cacheManager = this.flagshipConfig.getCacheManager();
        if (cacheManager != null) {
            try {
                CompletableFuture.supplyAsync(() -> {
                    IVisitorCacheImplementation cacheImplementation = cacheManager.getVisitorCacheImplementation();
                    if (cacheImplementation != null) {
                        JSONObject json = cacheImplementation.lookupVisitor(visitorDelegateDTO.getVisitorId());
                        VisitorCacheHelper.applyCacheToVisitor(visitorDelegateDTO, json != null ? json : new JSONObject());
                    }
                    return 0;
                }).get(cacheManager.getVisitorCacheLookupTimeout(), cacheManager.getTimeoutUnit());
            }
            catch (Exception e) {
                if (e instanceof TimeoutException) {
                    this.logCacheException(String.format("Error: '%s' for visitor '%s' has timed out.", "lookupVisitor", visitorDelegateDTO.getVisitorId()), e);
                }
                this.logCacheException(String.format("Error: '%s' for visitor '%s' threw an exception.", "lookupVisitor", visitorDelegateDTO.getVisitorId()), e);
            }
        }
    }

    @Override
    public void flushVisitorCache() {
        VisitorDelegateDTO visitorDelegateDTO = this.visitorDelegate.toDTO();
        CacheManager cacheManager = this.flagshipConfig.getCacheManager();
        if (cacheManager != null) {
            try {
                IVisitorCacheImplementation visitorCacheImplementation = cacheManager.getVisitorCacheImplementation();
                if (visitorCacheImplementation != null) {
                    visitorCacheImplementation.flushVisitor(visitorDelegateDTO.getVisitorId());
                }
            }
            catch (Exception e) {
                this.logCacheException(String.format("Error: '%s' for visitor '%s' threw an exception.", "flushVisitor", visitorDelegateDTO.getVisitorId()), e);
            }
        }
    }

    @Override
    public void lookupHitCache() {
        VisitorDelegateDTO visitorDelegateDTO = this.visitorDelegate.toDTO();
        CacheManager cacheManager = this.flagshipConfig.getCacheManager();
        if (cacheManager != null) {
            try {
                CompletableFuture.supplyAsync(() -> {
                    IHitCacheImplementation hitCacheImplementation = cacheManager.getHitCacheImplementation();
                    if (hitCacheImplementation != null) {
                        JSONArray array = hitCacheImplementation.lookupHits(visitorDelegateDTO.getVisitorId());
                        JSONArray result = array != null ? array : new JSONArray();
                        HitCacheHelper.applyHitMigration(visitorDelegateDTO, result);
                    }
                    return 0;
                }).get(cacheManager.getVisitorCacheLookupTimeout(), cacheManager.getTimeoutUnit());
            }
            catch (Exception e) {
                if (e instanceof TimeoutException) {
                    this.logCacheException(String.format("Error: '%s' for visitor '%s' has timed out.", "lookupHits", visitorDelegateDTO.getVisitorId()), e);
                }
                this.logCacheException(String.format("Error: '%s' for visitor '%s' threw an exception.", "lookupHits", visitorDelegateDTO.getVisitorId()), e);
            }
        }
    }

    @Override
    public void cacheHit(String visitorId, JSONObject data) {
        CacheManager cacheManager = this.flagshipConfig.getCacheManager();
        if (cacheManager != null) {
            try {
                IHitCacheImplementation hitCacheImplementation = cacheManager.getHitCacheImplementation();
                if (hitCacheImplementation != null) {
                    hitCacheImplementation.cacheHit(visitorId, data);
                }
            }
            catch (Exception e) {
                this.logCacheException(String.format("Error: '%s' for visitor '%s' threw an exception.", "cacheHit", visitorId), e);
            }
        }
    }

    @Override
    public void flushHitCache() {
        VisitorDelegateDTO visitorDelegateDTO = this.visitorDelegate.toDTO();
        CacheManager cacheManager = this.flagshipConfig.getCacheManager();
        if (cacheManager != null) {
            CompletableFuture.supplyAsync(() -> {
                try {
                    IHitCacheImplementation hitCacheImplementation = cacheManager.getHitCacheImplementation();
                    if (hitCacheImplementation != null) {
                        hitCacheImplementation.flushHits(visitorDelegateDTO.getVisitorId());
                    }
                }
                catch (Exception e) {
                    this.logCacheException(String.format("Error: '%s' for visitor '%s' threw an exception.", "flushHit", visitorDelegateDTO.getVisitorId()), e);
                }
                return 0;
            });
        }
    }

    @Override
    public CompletableFuture<Visitor> fetchFlags() {
        DecisionManager decisionManager = this.visitorDelegate.getConfigManager().getDecisionManager();
        return CompletableFuture.supplyAsync(() -> {
            try {
                VisitorDelegateDTO visitorDTO = this.visitorDelegate.toDTO();
                this.visitorDelegate.updateModifications(decisionManager.getCampaignsModifications(visitorDTO));
                this.visitorDelegate.logVisitor(FlagshipLogManager.Tag.FETCHING);
                this.visitorDelegate.getStrategy().cacheVisitor();
            }
            catch (Exception e) {
                FlagshipLogManager.exception(e);
            }
            return this.visitorDelegate.getOriginalVisitor();
        }, HttpManager.getInstance().getThreadPoolExecutor()).whenCompleteAsync((instance, error) -> this.visitorDelegate.logVisitor(FlagshipLogManager.Tag.FETCHING));
    }

    @Override
    public <T> Flag<T> getFlag(String key, T defaultValue) {
        return new Flag<T>(this.visitorDelegate, key, defaultValue);
    }

    private <T> Modification getModification(String key, T defaultValue) throws FlagshipConstants.Exceptions.FlagNotFoundException, FlagshipConstants.Exceptions.FlagTypeException, FlagshipConstants.Exceptions.FlagException {
        HashMap<String, Modification> modifications = new HashMap<String, Modification>(this.visitorDelegate.getModifications());
        try {
            Modification modification = modifications.get(key);
            if (modification != null) {
                Object castValue;
                Object object = castValue = modification.isReference() && modification.getValue() == null ? defaultValue : modification.getValue();
                if (defaultValue == null || castValue == null || castValue.getClass().equals(defaultValue.getClass())) {
                    return modification;
                }
                throw new FlagshipConstants.Exceptions.FlagTypeException();
            }
            throw new FlagshipConstants.Exceptions.FlagNotFoundException();
        }
        catch (Exception e) {
            if (e instanceof FlagshipConstants.Exceptions.FlagTypeException || e instanceof FlagshipConstants.Exceptions.FlagNotFoundException) {
                throw e;
            }
            throw new FlagshipConstants.Exceptions.FlagException();
        }
    }

    @Override
    public synchronized <T> T getFlagValue(String key, T defaultValue) {
        try {
            Modification modification = this.getModification(key, defaultValue);
            return (T)(modification.getValue() != null ? modification.getValue() : defaultValue);
        }
        catch (Exception e) {
            this.logFlagError(FlagshipLogManager.Tag.FLAG_VALUE, e, String.format("Default value will be returned for flag '%s': ", key));
            return defaultValue;
        }
    }

    @Override
    public synchronized <T> Modification getFlagMetadata(String key, T defaultValue) {
        try {
            return this.getModification(key, defaultValue);
        }
        catch (Exception e) {
            this.logFlagError(FlagshipLogManager.Tag.FLAG_METADATA, e, String.format("Empty metadata will be returned for Flag '%s': ", key));
            return null;
        }
    }

    @Override
    public synchronized <T> void exposeFlag(String key, T defaultValue) {
        try {
            Modification modification = this.getModification(key, defaultValue);
            if (!this.visitorDelegate.getActivatedVariations().contains(modification.getVariationId())) {
                this.visitorDelegate.getActivatedVariations().add(modification.getVariationId());
            }
            this.sendHit(new Activate(modification));
        }
        catch (Exception e) {
            this.logFlagError(FlagshipLogManager.Tag.FLAG_USER_EXPOSED, e, String.format("User exposition for Flag '%s' wont be sent: ", key));
        }
    }
}

