/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.visitor;

import com.abtasty.flagship.hits.Hit;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import com.abtasty.flagship.visitor.DefaultStrategy;
import com.abtasty.flagship.visitor.VisitorDelegate;
import org.json.JSONObject;

class NoConsentStrategy
extends DefaultStrategy {
    public NoConsentStrategy(VisitorDelegate visitor) {
        super(visitor);
    }

    protected void logMethodDeactivatedError(FlagshipLogManager.Tag tag, String visitorId, String methodName) {
        FlagshipLogManager.log(tag, LogManager.Level.ERROR, String.format("Method '%s' is deactivated for visitor '%s': visitor did not consent.", methodName, visitorId));
    }

    @Override
    public <T> void exposeFlag(String key, T defaultValue) {
        this.logMethodDeactivatedError(FlagshipLogManager.Tag.FLAG_USER_EXPOSED, this.visitorDelegate.getVisitorId(), "Flag.userExposed()");
    }

    @Override
    public <T> void sendHit(Hit<T> hit) {
        this.logMethodDeactivatedError(FlagshipLogManager.Tag.TRACKING, this.visitorDelegate.getVisitorId(), "sendHit()");
    }

    @Override
    public void sendContextRequest() {
    }

    @Override
    public void cacheVisitor() {
    }

    @Override
    public void lookupVisitorCache() {
    }

    @Override
    public void lookupHitCache() {
    }

    @Override
    public void cacheHit(String visitorId, JSONObject data) {
        JSONObject contentData;
        JSONObject jsonData;
        if (data.has("data") && (jsonData = data.getJSONObject("data")).has("content") && (contentData = jsonData.getJSONObject("content")).optString("ea").equals("fs_consent")) {
            super.cacheHit(visitorId, data);
        }
    }
}

