/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.visitor;

import com.abtasty.flagship.main.ConfigManager;
import com.abtasty.flagship.model.Modification;
import com.abtasty.flagship.visitor.VisitorDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class VisitorDelegateDTO {
    protected VisitorDelegate visitorDelegate;
    protected ConfigManager configManager;
    protected String visitorId;
    protected String anonymousId;
    protected HashMap<String, Object> context;
    protected HashMap<String, Modification> modifications;
    protected ArrayList<String> activatedVariations;
    protected boolean hasConsented;
    protected boolean isAuthenticated;
    protected HashMap<String, String> assignmentsHistory;

    public VisitorDelegateDTO(VisitorDelegate visitorDelegate) {
        this.visitorDelegate = visitorDelegate;
        this.configManager = visitorDelegate.getConfigManager();
        this.visitorId = visitorDelegate.getVisitorId();
        this.anonymousId = visitorDelegate.getAnonymousId();
        this.context = new HashMap<String, Object>(visitorDelegate.getContext());
        this.modifications = new HashMap<String, Modification>(visitorDelegate.getModifications());
        this.activatedVariations = new ArrayList<String>(visitorDelegate.getActivatedVariations());
        this.hasConsented = visitorDelegate.getConsent();
        this.isAuthenticated = visitorDelegate.isAuthenticated();
        this.assignmentsHistory = new HashMap<String, String>(visitorDelegate.getAssignmentsHistory());
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public String toString() {
        return new JSONObject().put("visitorId", (Object)this.visitorId).put("anonymousId", this.anonymousId != null ? this.anonymousId : JSONObject.NULL).put("isAuthenticated", this.isAuthenticated).put("hasConsented", this.hasConsented).put("context", (Object)this.contextToJson()).put("modifications", (Object)this.modificationsToJson()).put("activatedVariations", (Object)new JSONArray((Object)this.activatedVariations.toArray())).put("assignmentsHistory", (Object)new JSONObject(this.assignmentsHistory)).toString(2);
    }

    public JSONObject contextToJson() {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, Object> e : this.context.entrySet()) {
            json.put(e.getKey(), e.getValue());
        }
        return json;
    }

    public JSONObject modificationsToJson() {
        JSONObject json = new JSONObject();
        Iterator<Map.Entry<String, Modification>> iterator = this.modifications.entrySet().iterator();
        while (iterator.hasNext()) {
            Object value;
            Map.Entry<String, Modification> e;
            json.put(e.getKey(), (value = (e = iterator.next()).getValue().getValue()) != null ? value : JSONObject.NULL);
        }
        return json;
    }

    public String getVariationGroupAssignment(String variationGroupId) {
        return this.assignmentsHistory.getOrDefault(variationGroupId, null);
    }

    public void addNewAssignmentToHistory(String variationGroupId, String variationId) {
        this.assignmentsHistory.put(variationGroupId, variationId);
        this.visitorDelegate.getAssignmentsHistory().put(variationGroupId, variationId);
    }

    public String getVisitorId() {
        return this.visitorId;
    }

    public String getAnonymousId() {
        return this.anonymousId;
    }

    public HashMap<String, Object> getContext() {
        return this.context;
    }

    public HashMap<String, Modification> getModifications() {
        return this.modifications;
    }

    public ArrayList<String> getActivatedVariations() {
        return this.activatedVariations;
    }

    public boolean hasConsented() {
        return this.hasConsented;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public VisitorDelegate getVisitorDelegate() {
        return this.visitorDelegate;
    }

    public HashMap<String, String> getAssignmentsHistory() {
        return this.assignmentsHistory;
    }
}

