/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.visitor;

import com.abtasty.flagship.main.Flagship;
import com.abtasty.flagship.main.FlagshipConfig;
import com.abtasty.flagship.model.Modification;
import com.abtasty.flagship.utils.FlagshipConstants;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import com.abtasty.flagship.visitor.IVisitor;
import com.abtasty.flagship.visitor.VisitorDelegate;
import java.util.HashMap;
import org.json.JSONObject;

public abstract class VisitorStrategy
implements IVisitor {
    protected VisitorDelegate visitorDelegate;
    protected FlagshipConfig<?> flagshipConfig;

    public VisitorStrategy(VisitorDelegate visitorDelegate) {
        this.visitorDelegate = visitorDelegate;
        this.flagshipConfig = visitorDelegate.getConfigManager().getFlagshipConfig();
    }

    protected void logMethodDeactivatedError(FlagshipLogManager.Tag tag, String methodName) {
        FlagshipLogManager.log(tag, LogManager.Level.ERROR, String.format("Method '%s' is deactivated while SDK status is: %s.", new Object[]{methodName, Flagship.getStatus()}));
    }

    protected void logCacheException(String message, Exception e) {
        this.logCacheError(message);
        FlagshipLogManager.exception(e);
    }

    protected void logCacheError(String message) {
        FlagshipLogManager.log(FlagshipLogManager.Tag.CACHE, LogManager.Level.ERROR, message);
    }

    protected void logFlagError(FlagshipLogManager.Tag tag, Exception e, String message) {
        message = e instanceof FlagshipConstants.Exceptions.FlagTypeException ? (String)message + "Flag type and default value type are different." : (e instanceof FlagshipConstants.Exceptions.FlagNotFoundException ? (String)message + "Flag not found." : (String)message + "Unexpected Error.");
        FlagshipLogManager.log(tag, LogManager.Level.ERROR, (String)message);
    }

    public abstract void sendContextRequest();

    abstract void sendConsentRequest();

    abstract void loadContext(HashMap<String, Object> var1);

    public abstract void cacheVisitor();

    public abstract void lookupVisitorCache();

    public abstract void flushVisitorCache();

    public abstract void lookupHitCache();

    public abstract void cacheHit(String var1, JSONObject var2);

    public abstract void flushHitCache();

    public abstract <T> Modification getFlagMetadata(String var1, T var2);

    public abstract <T> T getFlagValue(String var1, T var2);

    public abstract <T> void exposeFlag(String var1, T var2);
}

