/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.api;

import com.abtasty.flagship.api.Response;
import com.abtasty.flagship.main.Flagship;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class HttpManager {
    private static volatile HttpManager instance = null;
    private final ThreadPoolExecutor threadPoolExecutor;
    private final long workerTimeout = 500L;
    private final TimeUnit workerTimeoutUnit = TimeUnit.MILLISECONDS;
    private int workers = Runtime.getRuntime().availableProcessors() * 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpManager getInstance() {
        if (instance != null) return instance;
        Class<Flagship> clazz = Flagship.class;
        synchronized (Flagship.class) {
            if (instance != null) return instance;
            instance = new HttpManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private HttpManager() {
        this.threadPoolExecutor = new ThreadPoolExecutor(this.workers, this.workers, this.workerTimeout, this.workerTimeoutUnit, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread t = new Thread(r, "Flagship Worker");
            t.setDaemon(true);
            return t;
        });
        this.threadPoolExecutor.allowCoreThreadTimeOut(true);
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    public HttpURLConnection createConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    public Response sendHttpRequest(RequestType type, String uri, HashMap<String, String> headers, String content) throws IOException {
        return this.sendHttpRequest(type, uri, headers, content, 0);
    }

    public Response sendHttpRequest(RequestType type, String uri, HashMap<String, String> headers, String content, int timeout) throws IOException {
        try {
            long timer = System.currentTimeMillis();
            URL url = new URL(uri);
            HttpURLConnection conn = this.createConnection(url);
            conn.setRequestMethod(type.name);
            conn.setRequestProperty("Content-Type", "application/json");
            if (timeout > 0) {
                conn.setConnectTimeout(timeout);
                conn.setReadTimeout(timeout);
            }
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> e : headers.entrySet()) {
                    conn.setRequestProperty(e.getKey(), e.getValue());
                }
            }
            if (type == RequestType.POST && content != null) {
                conn.setDoOutput(true);
                DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                out.writeBytes(content);
                out.flush();
                out.close();
            }
            Response response = this.parseResponse(conn, type, uri, headers, content);
            response.setResponseTime(System.currentTimeMillis() - timer);
            conn.disconnect();
            return response;
        }
        catch (Exception e) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.HTTP, LogManager.Level.ERROR, String.format("An error occurred while sending request to %s: %s", uri, e.getMessage() != null ? e.getMessage() : ""));
            return null;
        }
    }

    public CompletableFuture<Response> sendAsyncHttpRequest(RequestType type, String uri, HashMap<String, String> headers, String content) {
        return CompletableFuture.supplyAsync(() -> {
            Response response = null;
            try {
                response = this.sendHttpRequest(type, uri, headers, content);
            }
            catch (Exception e) {
                FlagshipLogManager.log(FlagshipLogManager.Tag.TRACKING, LogManager.Level.ERROR, String.format("An error occurred while sending request to %s: %s", uri, e.getMessage() != null ? e.getMessage() : ""));
            }
            return response;
        }, this.threadPoolExecutor);
    }

    public Response parseResponse(HttpURLConnection conn, RequestType requestType, String requestUri, HashMap<String, String> requestHeaders, String requestContent) throws IOException {
        String inputLine;
        int status = conn.getResponseCode();
        InputStream errorStream = conn.getErrorStream();
        InputStreamReader streamReader = new InputStreamReader(status >= 400 && errorStream != null ? errorStream : conn.getInputStream());
        BufferedReader in = new BufferedReader(streamReader);
        StringBuilder content = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            content.append(inputLine);
        }
        in.close();
        ((Reader)streamReader).close();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> e : conn.getHeaderFields().entrySet()) {
            if (e.getValue().size() <= 0) continue;
            headers.put(e.getKey(), e.getValue().get(0));
        }
        Response response = new Response(status, content.toString(), conn.getResponseMessage(), headers);
        response.setRequestHeaders(requestHeaders);
        response.setRequestUrl(requestUri);
        response.setRequestContent(requestContent);
        response.setType(requestType);
        return response;
    }

    public static enum RequestType {
        POST("POST"),
        GET("GET");

        public String name;

        private RequestType(String name) {
            this.name = name;
        }
    }
}

