/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.hits;

import com.abtasty.flagship.hits.Hit;
import com.abtasty.flagship.utils.FlagshipConstants;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;

public class Batch
extends Hit<Batch> {
    public static final int MAX_SIZE = 2500000;

    public Batch() {
        super(Hit.Type.BATCH);
        this.data.put(FlagshipConstants.HitKeyMap.HIT_BATCH, (Object)new JSONArray());
    }

    public void addChildAsJson(JSONObject child) {
        if (child.has("t") && child.has(FlagshipConstants.HitKeyMap.QUEUE_TIME)) {
            this.data.getJSONArray(FlagshipConstants.HitKeyMap.HIT_BATCH).put((Object)child);
        }
    }

    public boolean isMaxSizeReached(int lengthToAdd) {
        return 2500000 - this.data.toString().length() > lengthToAdd;
    }

    @Override
    public boolean checkData() {
        try {
            if (!Objects.equals(this.data.optString("t", ""), Hit.Type.BATCH.toString())) {
                return false;
            }
            JSONArray array = this.data.getJSONArray(FlagshipConstants.HitKeyMap.HIT_BATCH);
            if (array.length() == 0) {
                return false;
            }
            for (int i = 0; i < array.length(); ++i) {
                JSONObject item = array.getJSONObject(i);
                item.get("t");
                item.get(FlagshipConstants.HitKeyMap.QUEUE_TIME);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

