/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.model;

import com.abtasty.flagship.model.Modification;
import org.json.JSONObject;

public class FlagMetadata {
    public final String campaignId;
    public final String variationGroupId;
    public final String variationId;
    public final boolean isReference;
    public final String campaignType;
    public final String slug;

    public FlagMetadata() {
        this.campaignId = "";
        this.variationGroupId = "";
        this.variationId = "";
        this.isReference = false;
        this.campaignType = "";
        this.slug = "";
    }

    public FlagMetadata(String campaignId, String variationGroupId, String variationId, Boolean isReference, String campaignType, String slug) {
        this.campaignId = campaignId;
        this.variationGroupId = variationGroupId;
        this.variationId = variationId;
        this.isReference = isReference;
        this.campaignType = campaignType;
        this.slug = slug;
    }

    public static FlagMetadata fromModification(Modification modification) {
        if (modification == null) {
            return new FlagMetadata();
        }
        return new FlagMetadata(modification.getCampaignId(), modification.getVariationGroupId(), modification.getVariationId(), modification.isReference(), modification.getType(), modification.getSlug());
    }

    public boolean exists() {
        return !this.campaignId.isEmpty() && !this.variationGroupId.isEmpty() && !this.variationId.isEmpty();
    }

    public JSONObject toJSON() {
        if (!this.exists()) {
            return new JSONObject();
        }
        return new JSONObject().put("campaignId", (Object)this.campaignId).put("variationGroupId", (Object)this.variationGroupId).put("variationId", (Object)this.variationId).put("isReference", this.isReference).put("campaignType", (Object)this.campaignType).put("slug", (Object)this.slug);
    }
}

