/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.model;

import com.abtasty.flagship.model.TargetingGroups;
import com.abtasty.flagship.model.Variation;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import com.abtasty.flagship.utils.MurmurHash;
import com.abtasty.flagship.visitor.VisitorDelegateDTO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;

public class VariationGroup
implements Serializable {
    private final String campaignId;
    private final String variationGroupId;
    private final LinkedHashMap<String, Variation> variations;
    private final TargetingGroups targetingGroups;

    public VariationGroup(String campaignId, String variationGroupId, LinkedHashMap<String, Variation> variations, TargetingGroups targetingGroups) {
        this.campaignId = campaignId;
        this.variationGroupId = variationGroupId;
        this.targetingGroups = targetingGroups;
        this.variations = variations;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getVariationGroupId() {
        return this.variationGroupId;
    }

    public LinkedHashMap<String, Variation> getVariations() {
        return this.variations;
    }

    public TargetingGroups getTargetingGroups() {
        return this.targetingGroups;
    }

    public Variation selectVariation(VisitorDelegateDTO visitorDelegateDTO) {
        if (this.variations != null) {
            String cachedVariationId = visitorDelegateDTO.getVariationGroupAssignment(this.variationGroupId);
            Optional<Map.Entry> option = this.variations.entrySet().stream().filter(e -> ((Variation)e.getValue()).getVariationId().equals(cachedVariationId)).findFirst();
            if (option.isPresent()) {
                Variation v = (Variation)option.get().getValue();
                FlagshipLogManager.log(FlagshipLogManager.Tag.ALLOCATION, LogManager.Level.DEBUG, String.format("Variation %s selected from cache.", v.getVariationId()));
                return v;
            }
            if (cachedVariationId != null) {
                return null;
            }
            int p = 0;
            int murmurAllocation = MurmurHash.getAllocationFromMurmur(this.variationGroupId, visitorDelegateDTO.getVisitorId());
            for (Map.Entry<String, Variation> e2 : this.variations.entrySet()) {
                Variation variation = e2.getValue();
                if (variation.getAllocation() <= 0 || murmurAllocation >= (p += variation.getAllocation())) continue;
                FlagshipLogManager.log(FlagshipLogManager.Tag.ALLOCATION, LogManager.Level.DEBUG, String.format("Variation %s selected with allocation %d.", variation.getVariationId(), murmurAllocation));
                return variation;
            }
        }
        return null;
    }

    public boolean isTargetingValid(HashMap<String, Object> context) {
        if (this.targetingGroups != null) {
            return this.targetingGroups.isTargetingValid(context);
        }
        return true;
    }

    public static VariationGroup parse(String campaignId, String campaignType, String slug, JSONObject variationGroupsObj, boolean bucketing) {
        try {
            String variationGroupId = variationGroupsObj.getString(bucketing ? "id" : "variationGroupId");
            TargetingGroups targetingGroups = null;
            LinkedHashMap<String, Variation> variations = new LinkedHashMap<String, Variation>();
            if (!bucketing) {
                JSONObject variationObj = variationGroupsObj.getJSONObject("variation");
                Variation variation = Variation.parse(bucketing, campaignId, campaignType, slug, variationGroupId, variationObj);
                if (variation != null) {
                    variations.put(variation.getVariationId(), variation);
                }
            } else {
                JSONArray variationArr = variationGroupsObj.optJSONArray("variations");
                if (variationArr != null) {
                    JSONArray targetingArr;
                    for (int i = 0; i < variationArr.length(); ++i) {
                        JSONObject variationObj = variationArr.getJSONObject(i);
                        Variation variation = Variation.parse(bucketing, campaignId, campaignType, slug, variationGroupId, variationObj);
                        if (variation == null) continue;
                        variations.put(variation.getVariationId(), variation);
                    }
                    JSONObject targetingObj = variationGroupsObj.optJSONObject("targeting");
                    if (targetingObj != null && (targetingArr = targetingObj.optJSONArray("targetingGroups")) != null) {
                        targetingGroups = TargetingGroups.parse(targetingArr);
                    }
                }
            }
            return new VariationGroup(campaignId, variationGroupId, variations, targetingGroups);
        }
        catch (Exception e) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.PARSING, LogManager.Level.ERROR, "an error occurred while parsing  variation group.");
            return null;
        }
    }

    public String toString() {
        return "VariationGroup{campaignId='" + this.campaignId + "', variationGroupId='" + this.variationGroupId + "', variations=" + this.variations + ", targetingGroups=" + this.targetingGroups + "}";
    }
}

