/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.utils;

import com.abtasty.flagship.main.Flagship;
import com.abtasty.flagship.utils.LogManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class FlagshipLogManager
extends LogManager {
    private final String mainTag = "Flagship";
    private final Logger logger = Logger.getLogger(Flagship.class.getName());
    public static final String RESET = "\u001b[0m";
    public static final String RED = "\u001b[31m";
    public static final String GREEN = "\u001b[32m";
    public static final String YELLOW = "\u001b[33m";
    public static final String BLUE = "\u001b[34m";
    public static final String PURPLE = "\u001b[35m";
    public static final String CYAN = "\u001b[36m";
    public static final String WHITE = "\u001b[97m";

    public FlagshipLogManager(LogManager.Level mode) {
        super(mode);
        this.init();
    }

    public FlagshipLogManager() {
        this.init();
    }

    private void init() {
        ConsoleHandler h = new ConsoleHandler();
        h.setLevel(Level.ALL);
        LogFormatter formatter = new LogFormatter();
        h.setFormatter(formatter);
        this.logger.setUseParentHandlers(false);
        if (this.logger.getHandlers().length == 0) {
            this.logger.addHandler(h);
        }
    }

    public static void log(Tag tag, LogManager.Level level, String message) {
        LogManager logManager;
        if (Flagship.getConfig() != null && (logManager = Flagship.getConfig().getLogManager()) != null && tag != null && message != null) {
            logManager.newLog(level, tag.getName(), message);
        }
    }

    public static void exception(Exception e) {
        if (Flagship.getConfig() != null) {
            LogManager logManager = Flagship.getConfig().getLogManager();
            logManager.onException(e);
        }
    }

    private String exceptionToString(Exception e) {
        String strException = null;
        try {
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            e.printStackTrace(printer);
            strException = writer.toString();
            printer.close();
            writer.close();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        return strException;
    }

    private String currentDate() {
        SimpleDateFormat date_format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date resultDate = new Date(System.currentTimeMillis());
        return date_format.format(resultDate);
    }

    private String getColor(LogManager.Level level) {
        String color;
        switch (level) {
            case EXCEPTIONS: 
            case ERROR: {
                color = RED;
                break;
            }
            case WARNING: {
                color = YELLOW;
                break;
            }
            case DEBUG: {
                color = CYAN;
                break;
            }
            case INFO: {
                color = GREEN;
                break;
            }
            default: {
                color = WHITE;
            }
        }
        return color;
    }

    @Override
    public void onLog(LogManager.Level level, String tag, String message) {
        String log = String.format("%s[%s][%s][%s][%s] %s %s", new Object[]{this.getColor(level), this.currentDate(), this.mainTag, level, tag, message, RESET});
        this.logger.log(Level.INFO, log);
    }

    @Override
    public void onException(Exception e) {
        String strException = this.exceptionToString(e);
        this.onLog(LogManager.Level.EXCEPTIONS, Tag.EXCEPTION.getName(), strException);
    }

    public static class LogFormatter
    extends Formatter {
        @Override
        public String format(LogRecord record) {
            return String.format("%s\n", record.getMessage());
        }
    }

    public static enum Tag {
        GLOBAL("GLOBAL"),
        VISITOR("VISITOR"),
        INITIALIZATION("INITIALIZATION"),
        CONFIGURATION("CONFIGURATION"),
        BUCKETING("BUCKETING"),
        UPDATE_CONTEXT("UPDATE_CONTEXT"),
        CLEAR_CONTEXT("CLEAR_CONTEXT"),
        SYNCHRONIZE("SYNCHRONIZE"),
        CAMPAIGNS("CAMPAIGNS"),
        PARSING("PARSING"),
        TARGETING("TARGETING"),
        ALLOCATION("ALLOCATION"),
        FETCHING("FETCHING"),
        FLAG_VALUE("FLAG_VALUE"),
        FLAG_METADATA("FLAG_METADATA"),
        FLAG_USER_EXPOSED("FLAG_USER_EXPOSED"),
        HTTP("HTTP"),
        TRACKING("HIT"),
        ACTIVATE("ACTIVATE"),
        AUTHENTICATE("AUTHENTICATE"),
        UNAUTHENTICATE("UNAUTHENTICATE"),
        CONSENT("CONSENT"),
        EXCEPTION("EXCEPTION"),
        SQLITE_CACHE_MANAGER("SQLITE_CACHE_MANAGER"),
        CACHE("CACHE");

        String name;

        private Tag(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

