/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.visitor;

import com.abtasty.flagship.hits.Hit;
import com.abtasty.flagship.main.ConfigManager;
import com.abtasty.flagship.main.Flagship;
import com.abtasty.flagship.model.Flag;
import com.abtasty.flagship.utils.FlagshipContext;
import com.abtasty.flagship.visitor.IVisitor;
import com.abtasty.flagship.visitor.VisitorDelegate;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.json.JSONObject;

public class Visitor
implements IVisitor {
    VisitorDelegate delegate;

    private Visitor(ConfigManager configManager, String visitorId, Boolean isAuthenticated, Boolean hasConsented, HashMap<String, Object> context) {
        this.delegate = new VisitorDelegate(this, configManager, visitorId, isAuthenticated, hasConsented, context);
    }

    public synchronized String getId() {
        return this.delegate.getVisitorId();
    }

    public synchronized String getAnonymousId() {
        return this.delegate.getAnonymousId();
    }

    @Override
    public synchronized void updateContext(HashMap<String, Object> context) {
        this.delegate.getStrategy().updateContext(context);
    }

    @Override
    public synchronized <T> void updateContext(String key, T value) {
        this.delegate.getStrategy().updateContext(key, value);
    }

    @Override
    public synchronized <T> void updateContext(FlagshipContext<T> flagshipContext, T value) {
        this.delegate.getStrategy().updateContext(flagshipContext, value);
    }

    @Override
    public synchronized void clearContext() {
        this.delegate.getStrategy().clearContext();
    }

    @Deprecated
    public synchronized CompletableFuture<Visitor> synchronizeModifications() {
        return this.delegate.getStrategy().fetchFlags();
    }

    @Deprecated
    public synchronized <T> T getModification(String key, T defaultValue) {
        return this.delegate.getStrategy().getFlag(key, defaultValue).value(false);
    }

    @Deprecated
    public synchronized <T> T getModification(String key, T defaultValue, boolean activate) {
        return this.delegate.getStrategy().getFlag(key, defaultValue).value(activate);
    }

    @Deprecated
    public synchronized JSONObject getModificationInfo(String key) {
        JSONObject json = this.delegate.getStrategy().getFlag(key, null).metadata().toJSON();
        return json.length() == 0 ? null : json;
    }

    @Deprecated
    public synchronized void activateModification(String key) {
        this.delegate.getStrategy().getFlag(key, null).userExposed();
    }

    @Override
    public synchronized CompletableFuture<Visitor> fetchFlags() {
        return this.delegate.getStrategy().fetchFlags();
    }

    @Override
    public synchronized <T> Flag<T> getFlag(String key, T defaultValue) {
        return this.delegate.getStrategy().getFlag(key, defaultValue);
    }

    @Override
    public synchronized <T> void sendHit(Hit<T> hit) {
        this.delegate.getStrategy().sendHit(hit);
    }

    @Override
    public synchronized void authenticate(String visitorId) {
        this.delegate.getStrategy().authenticate(visitorId);
    }

    @Override
    public synchronized void unauthenticate() {
        this.delegate.getStrategy().unauthenticate();
    }

    @Override
    public synchronized void setConsent(Boolean hasConsented) {
        this.delegate.getStrategy().setConsent(hasConsented);
    }

    @Override
    public synchronized Boolean hasConsented() {
        return this.delegate.getStrategy().hasConsented();
    }

    public synchronized HashMap<String, Object> getContext() {
        return this.delegate.getContextCopy();
    }

    public synchronized String toString() {
        return this.delegate.toString();
    }

    public static class Builder {
        private Instance instanceType = Instance.SINGLE_INSTANCE;
        private final ConfigManager configManager;
        private final String visitorId;
        private boolean isAuthenticated = false;
        private boolean hasConsented = true;
        private HashMap<String, Object> context = null;

        public Builder(Instance instanceType, ConfigManager configManager, String visitorId) {
            this.instanceType = instanceType;
            this.configManager = configManager;
            this.visitorId = visitorId;
        }

        public Builder isAuthenticated(boolean isAuthenticated) {
            this.isAuthenticated = isAuthenticated;
            return this;
        }

        public Builder hasConsented(boolean hasConsented) {
            this.hasConsented = hasConsented;
            return this;
        }

        public Builder context(HashMap<String, Object> context) {
            this.context = context;
            return this;
        }

        public Visitor build() {
            Visitor visitor = new Visitor(this.configManager, this.visitorId, this.isAuthenticated, this.hasConsented, this.context);
            if (this.instanceType == Instance.SINGLE_INSTANCE) {
                Flagship.setSingleVisitorInstance(visitor);
            }
            return visitor;
        }
    }

    public static enum Instance {
        SINGLE_INSTANCE,
        NEW_INSTANCE;

    }
}

