/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.visitor;

import com.abtasty.flagship.main.ConfigManager;
import com.abtasty.flagship.main.Flagship;
import com.abtasty.flagship.model.Modification;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import com.abtasty.flagship.visitor.DefaultStrategy;
import com.abtasty.flagship.visitor.NoConsentStrategy;
import com.abtasty.flagship.visitor.NotReadyStrategy;
import com.abtasty.flagship.visitor.PanicStrategy;
import com.abtasty.flagship.visitor.Visitor;
import com.abtasty.flagship.visitor.VisitorDelegateDTO;
import com.abtasty.flagship.visitor.VisitorStrategy;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public class VisitorDelegate {
    private final Visitor originalVisitor;
    private final ConfigManager configManager;
    private String visitorId;
    private String anonymousId;
    private final ConcurrentMap<String, Object> context = new ConcurrentHashMap<String, Object>();
    private final ConcurrentMap<String, Modification> modifications = new ConcurrentHashMap<String, Modification>();
    private final ConcurrentLinkedQueue<String> activatedVariations = new ConcurrentLinkedQueue();
    private Boolean hasConsented;
    private Boolean isAuthenticated;
    private final ConcurrentHashMap<String, String> assignmentsHistory = new ConcurrentHashMap();

    public VisitorDelegate(Visitor originalVisitor, ConfigManager configManager, String visitorId, Boolean isAuthenticated, Boolean hasConsented, HashMap<String, Object> context) {
        this.originalVisitor = originalVisitor;
        this.configManager = configManager;
        this.visitorId = visitorId == null || visitorId.length() <= 0 ? this.genVisitorId() : visitorId;
        this.isAuthenticated = isAuthenticated;
        this.hasConsented = hasConsented;
        this.anonymousId = this.configManager.getFlagshipConfig().getDecisionMode() == Flagship.DecisionMode.API && isAuthenticated != false ? this.genVisitorId() : null;
        this.getStrategy().lookupVisitorCache();
        this.getStrategy().lookupHitCache();
        this.loadContext(context);
        this.getStrategy().sendConsentRequest();
        this.logVisitor(FlagshipLogManager.Tag.VISITOR);
    }

    public VisitorStrategy getStrategy() {
        if (Flagship.getStatus().lessThan(Flagship.Status.PANIC)) {
            return new NotReadyStrategy(this);
        }
        if (Flagship.getStatus() == Flagship.Status.PANIC) {
            return new PanicStrategy(this);
        }
        if (!this.hasConsented.booleanValue()) {
            return new NoConsentStrategy(this);
        }
        return new DefaultStrategy(this);
    }

    private String genVisitorId() {
        FlagshipLogManager.log(FlagshipLogManager.Tag.VISITOR, LogManager.Level.WARNING, "Visitor identifier must not be null or empty. A UUID has been generated.");
        return UUID.randomUUID().toString();
    }

    HashMap<String, Object> getContextCopy() {
        return new HashMap<String, Object>(this.context);
    }

    void loadContext(HashMap<String, Object> newContext) {
        this.getStrategy().loadContext(newContext);
    }

    protected void logVisitor(FlagshipLogManager.Tag tag) {
        String visitorStr = String.format("'%s' \n%s", this.visitorId, this);
        FlagshipLogManager.log(tag, LogManager.Level.DEBUG, visitorStr);
    }

    public void updateModifications(HashMap<String, Modification> modifications) {
        if (modifications != null) {
            this.modifications.clear();
            this.modifications.putAll(modifications);
        }
    }

    protected VisitorDelegateDTO toDTO() {
        return new VisitorDelegateDTO(this);
    }

    public String toString() {
        return this.toDTO().toString();
    }

    public synchronized Visitor getOriginalVisitor() {
        return this.originalVisitor;
    }

    public synchronized ConfigManager getConfigManager() {
        return this.configManager;
    }

    public synchronized String getVisitorId() {
        return this.visitorId;
    }

    public synchronized void setVisitorId(String visitorId) {
        this.visitorId = visitorId;
    }

    public synchronized String getAnonymousId() {
        return this.anonymousId;
    }

    public synchronized void setAnonymousId(String anonymousId) {
        this.anonymousId = anonymousId;
    }

    public synchronized ConcurrentMap<String, Modification> getModifications() {
        return this.modifications;
    }

    public synchronized ConcurrentLinkedQueue<String> getActivatedVariations() {
        return this.activatedVariations;
    }

    public synchronized Boolean getConsent() {
        return this.hasConsented;
    }

    public synchronized void setConsent(Boolean hasConsented) {
        this.hasConsented = hasConsented;
    }

    public synchronized Boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public synchronized void isAuthenticated(Boolean authenticated) {
        this.isAuthenticated = authenticated;
    }

    public synchronized ConcurrentHashMap<String, String> getAssignmentsHistory() {
        return this.assignmentsHistory;
    }

    public synchronized ConcurrentMap<String, Object> getContext() {
        return this.context;
    }
}

