/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.api;

import com.abtasty.flagship.api.HttpManager;
import java.util.HashMap;
import org.json.JSONObject;

public class Response {
    private HttpManager.RequestType type = HttpManager.RequestType.GET;
    private String requestUrl = "";
    private String requestContent = "";
    private HashMap<String, String> requestHeaders = new HashMap();
    private int responseCode;
    private String responseContent;
    private String responseMessage;
    private HashMap<String, String> responseHeaders;
    private long responseTime = 0L;

    public Response(int code, String content, String message, HashMap<String, String> headers) {
        this.responseCode = code;
        this.responseContent = content;
        this.responseMessage = message;
        this.responseHeaders = headers;
    }

    public Boolean isSuccess() {
        return this.responseCode < 400;
    }

    public Boolean isSuccess(Boolean ignoreNoModification) {
        return !ignoreNoModification.booleanValue() ? this.responseCode < 300 : this.responseCode < 400;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public String getRequestContent() {
        return this.requestContent;
    }

    public JSONObject getRequestContentAsJson() {
        try {
            return new JSONObject(this.getRequestContent());
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }

    public void setRequestContent(String requestContent) {
        this.requestContent = requestContent;
    }

    public HashMap<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(HashMap<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseContent() {
        return this.responseContent;
    }

    public void setResponseContent(String responseContent) {
        this.responseContent = responseContent;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public HashMap<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(HashMap<String, String> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public String getResponseHeader(String field) {
        return this.responseHeaders.get(field);
    }

    public HttpManager.RequestType getType() {
        return this.type;
    }

    public void setType(HttpManager.RequestType type) {
        this.type = type;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    public String toString() {
        return "Response{type=" + (Object)((Object)this.type) + ", requestUrl='" + this.requestUrl + '\'' + ", requestContent='" + this.requestContent + '\'' + ", requestHeaders=" + this.requestHeaders + ", responseCode=" + this.responseCode + ", responseContent='" + this.responseContent + '\'' + ", responseMessage='" + this.responseMessage + '\'' + ", responseHeaders=" + this.responseHeaders + '}';
    }
}

