/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.cache;

import com.abtasty.flagship.cache.IHitCacheImplementation;
import com.abtasty.flagship.cache.IVisitorCacheImplementation;
import java.util.concurrent.TimeUnit;

public abstract class CacheManager {
    protected TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;
    protected Long visitorCacheLookupTimeout = 200L;
    protected Long hitCacheLookupTimeout = 200L;
    protected IVisitorCacheImplementation visitorCacheImplementation = null;
    protected IHitCacheImplementation hitCacheImplementation = null;

    public Long getVisitorCacheLookupTimeout() {
        return this.visitorCacheLookupTimeout;
    }

    public Long getHitCacheLookupTimeout() {
        return this.hitCacheLookupTimeout;
    }

    public IVisitorCacheImplementation getVisitorCacheImplementation() {
        return this.visitorCacheImplementation;
    }

    public IHitCacheImplementation getHitCacheImplementation() {
        return this.hitCacheImplementation;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public static class Builder {
        private CacheManager cacheManager = new CacheManager(){};

        public Builder withVisitorCacheLookupTimeout(Long timeout) {
            this.cacheManager.visitorCacheLookupTimeout = timeout;
            return this;
        }

        public Builder withHitCacheLookupTimeout(Long timeout) {
            this.cacheManager.hitCacheLookupTimeout = timeout;
            return this;
        }

        public Builder withVisitorCacheImplementation(IVisitorCacheImplementation implementation) {
            this.cacheManager.visitorCacheImplementation = implementation;
            return this;
        }

        public Builder withHitCacheImplementation(IHitCacheImplementation implementation) {
            this.cacheManager.hitCacheImplementation = implementation;
            return this;
        }

        public CacheManager build() {
            return this.cacheManager;
        }
    }

    public static class NoCache
    extends CacheManager {
    }
}

