/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.decision;

import com.abtasty.flagship.api.HttpManager;
import com.abtasty.flagship.api.Response;
import com.abtasty.flagship.decision.DecisionManager;
import com.abtasty.flagship.main.Flagship;
import com.abtasty.flagship.main.FlagshipConfig;
import com.abtasty.flagship.model.Campaign;
import com.abtasty.flagship.model.Modification;
import com.abtasty.flagship.model.Variation;
import com.abtasty.flagship.model.VariationGroup;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import com.abtasty.flagship.visitor.VisitorDelegateDTO;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class BucketingManager
extends DecisionManager {
    private final String DECISION_FILE_NAME = "decision_file.json";
    private final String DECISION_FILE = "decision_file";
    private final String LAST_MODIFIED_DECISION_FILE = "last_modified";
    private String lastModified;
    private String decisionFile;
    private ArrayList<Campaign> campaigns = new ArrayList();
    private ScheduledExecutorService executor;

    public BucketingManager(FlagshipConfig<?> config) {
        super(config);
        this.startPolling();
    }

    @Override
    public void setStatusListener(Flagship.StatusListener statusListener) {
        super.setStatusListener(statusListener);
        if (Flagship.getStatus().lessThan(Flagship.Status.READY)) {
            statusListener.onStatusChanged(Flagship.Status.POLLING);
        }
    }

    public void startPolling() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            });
            Runnable runnable = () -> {
                FlagshipLogManager.log(FlagshipLogManager.Tag.BUCKETING, LogManager.Level.DEBUG, "Polling event.");
                this.updateBucketingCampaigns();
            };
            long time = this.config.getPollingTime();
            TimeUnit unit = this.config.getPollingUnit();
            if (time == 0L) {
                this.executor.execute(runnable);
            } else {
                this.executor.scheduleAtFixedRate(runnable, 0L, time, unit);
            }
        }
    }

    private void updateBucketingCampaigns() {
        try {
            Response response;
            block7: {
                HashMap<String, String> headers = new HashMap<String, String>();
                this.loadDecisionFile();
                if (this.lastModified != null) {
                    headers.put("If-Modified-Since", this.lastModified);
                }
                response = null;
                try {
                    response = HttpManager.getInstance().sendHttpRequest(HttpManager.RequestType.GET, String.format("https://cdn.flagship.io/%s/bucketing.json", this.config.getEnvId()), headers, null, this.config.getTimeout());
                }
                catch (Exception e) {
                    FlagshipLogManager.log(FlagshipLogManager.Tag.BUCKETING, LogManager.Level.ERROR, String.format("An error occurred during Bucketing polling: %s.", e.getMessage() != null ? e.getMessage() : ""));
                    if (this.decisionFile == null) break block7;
                    FlagshipLogManager.log(FlagshipLogManager.Tag.BUCKETING, LogManager.Level.INFO, String.format("Bucketing file have been loaded from cache (%s): \n%s.", this.lastModified, new JSONObject(this.decisionFile).toString(4)));
                }
            }
            if (response != null) {
                this.logResponse(response);
                if (response.getResponseCode() < 300) {
                    this.lastModified = response.getResponseHeader("Last-Modified");
                    this.decisionFile = response.getResponseContent();
                    this.saveDecisionFile();
                }
            }
            this.parseDecisionFile();
        }
        catch (Exception e) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.FETCHING, LogManager.Level.ERROR, e.getMessage() != null ? e.getMessage() : "");
        }
        this.updateFlagshipStatus(this.isPanic() ? Flagship.Status.PANIC : Flagship.Status.READY);
    }

    private void parseDecisionFile() {
        ArrayList<Campaign> campaigns;
        if (this.decisionFile != null && (campaigns = this.parseCampaignsResponse(this.decisionFile)) != null) {
            this.campaigns = campaigns;
        }
    }

    @Override
    public void stop() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
        this.executor = null;
    }

    @Override
    public HashMap<String, Modification> getCampaignsModifications(VisitorDelegateDTO visitorDelegateDTO) {
        try {
            if (this.campaigns != null) {
                HashMap<String, Modification> campaignsModifications = new HashMap<String, Modification>();
                block2: for (Campaign campaign : this.campaigns) {
                    for (VariationGroup variationGroup : campaign.getVariationGroups()) {
                        Variation variation;
                        if (!variationGroup.isTargetingValid(new HashMap<String, Object>(visitorDelegateDTO.getContext())) || (variation = variationGroup.selectVariation(visitorDelegateDTO)) == null) continue;
                        visitorDelegateDTO.addNewAssignmentToHistory(variation.getVariationGroupId(), variation.getVariationId());
                        HashMap<String, Modification> modificationsValues = variation.getModificationsValues();
                        if (modificationsValues == null) continue block2;
                        campaignsModifications.putAll(modificationsValues);
                        continue block2;
                    }
                }
                visitorDelegateDTO.getVisitorDelegate().getStrategy().sendContextRequest();
                return campaignsModifications;
            }
        }
        catch (Exception e) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.FETCHING, LogManager.Level.ERROR, e.getMessage() != null ? e.getMessage() : "");
        }
        return null;
    }

    public void saveDecisionFile() {
        if (this.lastModified != null && this.decisionFile != null) {
            try {
                JSONObject decisionJson = new JSONObject().put("last_modified", (Object)this.lastModified).put("decision_file", (Object)new JSONObject(this.decisionFile));
                FileWriter fWriter = new FileWriter("decision_file.json", false);
                BufferedWriter fOut = new BufferedWriter(fWriter);
                fOut.write(decisionJson.toString());
                fOut.close();
                fWriter.close();
            }
            catch (Exception e) {
                FlagshipLogManager.log(FlagshipLogManager.Tag.BUCKETING, LogManager.Level.ERROR, String.format("Bucketing file failed to be saved: %s.", e.getMessage() != null ? e.getMessage() : ""));
            }
        }
    }

    public void loadDecisionFile() {
        try {
            StringBuilder builder = new StringBuilder();
            BufferedReader reader = new BufferedReader(new FileReader("decision_file.json"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            reader.close();
            String content = builder.toString();
            if (!content.isEmpty()) {
                JSONObject decisionJson = new JSONObject(content);
                this.lastModified = decisionJson.optString("last_modified", null);
                this.decisionFile = decisionJson.optString("decision_file", null);
            }
        }
        catch (Exception e) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.BUCKETING, LogManager.Level.ERROR, String.format("Bucketing file failed to be loaded: %s.", e.getMessage() != null ? e.getMessage() : ""));
        }
    }
}

