/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.utils;

public abstract class LogManager {
    protected Level level;

    public LogManager() {
        this.level = Level.ALL;
    }

    public LogManager(Level level) {
        this.level = level == null ? Level.NONE : level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    protected final void newLog(Level level, String tag, String message) {
        if (this.level.isAllowed(level)) {
            this.onLog(level, tag, message);
        }
    }

    public abstract void onLog(Level var1, String var2, String var3);

    public void onException(Exception e) {
    }

    public static enum Level {
        NONE(0),
        EXCEPTIONS(1),
        ERROR(2),
        WARNING(3),
        DEBUG(4),
        INFO(5),
        ALL(6);

        int level;

        private Level(int level) {
            this.level = level;
        }

        public final boolean isAllowed(Level newLevel) {
            return newLevel.level < this.level || newLevel.level == this.level;
        }
    }
}

