/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.cache;

import com.abtasty.flagship.cache.CacheHelper;
import com.abtasty.flagship.hits.Batch;
import com.abtasty.flagship.hits.Hit;
import com.abtasty.flagship.utils.FlagshipConstants;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import com.abtasty.flagship.visitor.VisitorDelegateDTO;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONObject;

public class HitCacheHelper
extends CacheHelper {
    public static final int _HIT_CACHE_VERSION_ = 1;

    public static JSONObject fromHit(VisitorDelegateDTO visitorDelegateDTO, String type, JSONObject hitData, long time) {
        return new JSONObject().put("version", 1).put("data", (Object)new JSONObject().put("time", time > -1L ? time : System.currentTimeMillis()).put("visitorId", (Object)visitorDelegateDTO.getVisitorId()).put("anonymousId", visitorDelegateDTO.getAnonymousId() != null ? visitorDelegateDTO.getAnonymousId() : JSONObject.NULL).put("type", (Object)type).put("content", (Object)hitData));
    }

    private static Batch findFirstAvailableBatch(ArrayList<Batch> batches, int len) {
        for (int i = 0; i < batches.size(); ++i) {
            if (!batches.get(i).isMaxSizeReached(len)) continue;
            return batches.get(i);
        }
        return null;
    }

    public static void applyHitMigration(VisitorDelegateDTO visitorDelegateDTO, JSONArray result) {
        if (result.length() > 0) {
            ArrayList<Batch> batches = new ArrayList<Batch>();
            for (int i = 0; i < result.length(); ++i) {
                JSONObject e = result.getJSONObject(i);
                int version = 0;
                try {
                    JSONObject jsonChild;
                    version = e.getInt("version");
                    if (version <= 0) continue;
                    String type = e.getJSONObject("data").getString("type");
                    if (Arrays.asList("CONTEXT", "ACTIVATION", "BATCH").contains(type)) {
                        HitMigrations.values()[version - 1].applyForEvent(visitorDelegateDTO, e);
                        continue;
                    }
                    if (!Arrays.asList("SCREENVIEW", "PAGEVIEW", "EVENT", "TRANSACTION", "ITEM", "CONSENT").contains(type) || (jsonChild = HitMigrations.values()[version - 1].applyForBatch(visitorDelegateDTO, e)) == null) continue;
                    Batch batch = HitCacheHelper.findFirstAvailableBatch(batches, jsonChild.toString().length());
                    if (batch == null) {
                        Batch newBatch = new Batch();
                        newBatch.addChildAsJson(jsonChild);
                        batches.add(newBatch);
                        continue;
                    }
                    batch.addChildAsJson(jsonChild);
                    continue;
                }
                catch (Exception ex) {
                    FlagshipLogManager.log(FlagshipLogManager.Tag.CACHE, LogManager.Level.ERROR, String.format("Error: '%s' have loaded a bad format version (%d) for visitor '%s'.", "lookupHits", version, visitorDelegateDTO.getVisitorId()));
                }
            }
            for (int j = 0; j < batches.size(); ++j) {
                visitorDelegateDTO.getConfigManager().getTrackingManager().sendHit(visitorDelegateDTO, (Hit)batches.get(j));
            }
        }
    }

    static enum HitMigrations implements CacheHitMigrationInterface
    {
        MIGRATION_1{

            @Override
            public JSONObject applyForBatch(VisitorDelegateDTO visitorDelegateDTO, JSONObject data) {
                JSONObject jsonData = data.getJSONObject("data");
                if (jsonData.getString("visitorId").equals(visitorDelegateDTO.getVisitorId())) {
                    long time = jsonData.getLong("time");
                    if (System.currentTimeMillis() <= time + 14400000L) {
                        JSONObject jsonContent = jsonData.getJSONObject("content");
                        jsonContent.remove("cid");
                        jsonContent.remove("vid");
                        jsonContent.remove("cuid");
                        jsonContent.remove("ds");
                        jsonContent.remove("ul");
                        jsonContent.remove("sr");
                        jsonContent.put(FlagshipConstants.HitKeyMap.QUEUE_TIME, System.currentTimeMillis() - time);
                        return jsonContent;
                    }
                }
                return null;
            }

            @Override
            public void applyForEvent(VisitorDelegateDTO visitorDelegateDTO, JSONObject data) {
                JSONObject jsonData = data.getJSONObject("data");
                if (jsonData.get("visitorId").equals(visitorDelegateDTO.getVisitorId())) {
                    long time = jsonData.getLong("time");
                    String type = jsonData.getString("type");
                    JSONObject content = jsonData.getJSONObject("content");
                    if (System.currentTimeMillis() <= time + 14400000L) {
                        visitorDelegateDTO.getConfigManager().getTrackingManager().sendHit(visitorDelegateDTO, type, time, content);
                    }
                }
            }
        };

    }

    static interface CacheHitMigrationInterface {
        public JSONObject applyForBatch(VisitorDelegateDTO var1, JSONObject var2);

        public void applyForEvent(VisitorDelegateDTO var1, JSONObject var2);
    }
}

