/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.database;

import com.abtasty.flagship.cache.CacheManager;
import com.abtasty.flagship.cache.IHitCacheImplementation;
import com.abtasty.flagship.cache.IVisitorCacheImplementation;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class SQLiteCacheManager
extends CacheManager {
    private static final String databaseName = "flagship_database.db";
    private String databasePath = "./";
    private String url = "jdbc:sqlite:" + this.databasePath + "flagship_database.db";
    String _CREATE_VISITORS_TABLE_ = "CREATE TABLE IF NOT EXISTS visitors (\n\tvisitorId VARCHAR(100) UNIQUE PRIMARY KEY,\n\tcontent text NOT NULL\n);";
    String _CREATE_HITS_TABLE_ = "CREATE TABLE IF NOT EXISTS hits (\n id INTEGER PRIMARY KEY AUTOINCREMENT,\n\tvisitorId VARCHAR(100),\n\tcontent text NOT NULL\n);";
    IVisitorCacheImplementation cacheVisitorImplementation = new IVisitorCacheImplementation(){

        @Override
        public void cacheVisitor(String visitorId, JSONObject data) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.SQLITE_CACHE_MANAGER, LogManager.Level.INFO, String.format("[cacheVisitor] Visitor '%s' has been saved into database:\n%s.", visitorId, data.toString(4)));
            SQLiteCacheManager.this.upsertVisitor(visitorId, data);
        }

        @Override
        public JSONObject lookupVisitor(String visitorId) {
            JSONObject result = SQLiteCacheManager.this.getVisitor(visitorId);
            FlagshipLogManager.log(FlagshipLogManager.Tag.SQLITE_CACHE_MANAGER, LogManager.Level.INFO, String.format("[lookupVisitor] Visitor '%s' has been loaded from database:\n%s.", visitorId, result.toString(4)));
            return result;
        }

        @Override
        public void flushVisitor(String visitorId) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.SQLITE_CACHE_MANAGER, LogManager.Level.INFO, String.format("[flushVisitor] Visitor '%s' has been flushed from database.", visitorId));
            SQLiteCacheManager.this.deleteVisitor(visitorId);
        }
    };
    IHitCacheImplementation hitCacheImplementation = new IHitCacheImplementation(){

        @Override
        public void cacheHit(String visitorId, JSONObject data) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.SQLITE_CACHE_MANAGER, LogManager.Level.INFO, String.format("[cacheHit] Hit for visitor '%s' has been saved into database:\n%s.", visitorId, data.toString(4)));
            SQLiteCacheManager.this.insertHit(visitorId, data);
        }

        @Override
        public JSONArray lookupHits(String visitorId) {
            JSONArray result = SQLiteCacheManager.this.getHits(visitorId);
            FlagshipLogManager.log(FlagshipLogManager.Tag.SQLITE_CACHE_MANAGER, LogManager.Level.INFO, String.format("[lookupHits] hits for visitor '%s' has been loaded from database:\n%s.", visitorId, result.toString(4)));
            return result;
        }

        @Override
        public void flushHits(String visitorId) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.SQLITE_CACHE_MANAGER, LogManager.Level.INFO, String.format("[flushHits] Hits for visitor '%s' has been flushed from database.", visitorId));
            SQLiteCacheManager.this.deleteHits(visitorId);
        }
    };

    public SQLiteCacheManager() {
        this.createDatabase();
    }

    public SQLiteCacheManager(String path) {
        try {
            this.databasePath = path + (!path.endsWith("/") ? "/" : "");
            Files.createDirectories(Paths.get(this.databasePath, new String[0]), new FileAttribute[0]);
            this.url = "jdbc:sqlite:" + this.databasePath + databaseName;
        }
        catch (Exception e) {
            FlagshipLogManager.exception(e);
        }
        this.createDatabase();
    }

    private synchronized Connection connect() {
        try {
            return DriverManager.getConnection(this.url);
        }
        catch (Exception e) {
            FlagshipLogManager.exception(e);
            return null;
        }
    }

    private synchronized void createDatabase() {
        try (Connection conn = this.connect();){
            if (conn != null) {
                DatabaseMetaData meta = conn.getMetaData();
                FlagshipLogManager.log(FlagshipLogManager.Tag.CACHE, LogManager.Level.INFO, String.format("A new sqlite database has been created at: %s", meta.getURL()));
                Statement statement = conn.createStatement();
                statement.execute(this._CREATE_VISITORS_TABLE_);
                statement.execute(this._CREATE_HITS_TABLE_);
            }
        }
        catch (SQLException e) {
            FlagshipLogManager.exception(e);
        }
    }

    private synchronized int upsertVisitor(String visitorId, JSONObject data) {
        int results = 0;
        boolean exists = this.isVisitorExists(visitorId);
        String sql = !exists ? "INSERT INTO visitors(visitorId,content) VALUES(?,?)" : "UPDATE visitors SET content = ? WHERE visitorId = ?";
        try (Connection conn = this.connect();){
            if (conn != null) {
                PreparedStatement statement = conn.prepareStatement(sql);
                if (!exists) {
                    statement.setString(1, visitorId);
                    statement.setString(2, data.toString());
                } else {
                    statement.setString(1, data.toString());
                    statement.setString(2, visitorId);
                }
                results = statement.executeUpdate();
                statement.close();
            }
        }
        catch (Exception e) {
            FlagshipLogManager.exception(e);
        }
        return results;
    }

    private synchronized boolean isVisitorExists(String visitorId) {
        boolean result = false;
        String sql = "SELECT visitorId, content FROM visitors WHERE visitorId = ?";
        try (Connection conn = this.connect();){
            if (conn != null) {
                PreparedStatement statement = conn.prepareStatement(sql);
                statement.setString(1, visitorId);
                ResultSet rs = statement.executeQuery();
                result = rs.next();
                rs.close();
                statement.close();
            }
        }
        catch (Exception e) {
            FlagshipLogManager.exception(e);
        }
        return result;
    }

    private synchronized JSONObject getVisitor(String visitorId) {
        JSONObject result = new JSONObject();
        String sql = "SELECT visitorId, content FROM visitors WHERE visitorId = ?";
        try (Connection conn = this.connect();){
            if (conn != null) {
                PreparedStatement statement = conn.prepareStatement(sql);
                statement.setString(1, visitorId);
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    result = new JSONObject(rs.getString("content"));
                }
                rs.close();
                statement.close();
            }
        }
        catch (Exception e) {
            FlagshipLogManager.exception(e);
        }
        return result;
    }

    private synchronized int deleteVisitor(String visitorId) {
        int result = 0;
        String sql = "DELETE FROM visitors WHERE visitorId = ?";
        try (Connection conn = this.connect();){
            if (conn != null) {
                PreparedStatement statement = conn.prepareStatement(sql);
                statement.setString(1, visitorId);
                result = statement.executeUpdate();
                statement.close();
            }
        }
        catch (SQLException e) {
            FlagshipLogManager.exception(e);
        }
        return result;
    }

    private synchronized int insertHit(String visitorId, JSONObject data) {
        int result = 0;
        String sql = "INSERT INTO hits(visitorId,content) VALUES(?,?)";
        try (Connection conn = this.connect();){
            if (conn != null) {
                PreparedStatement statement = conn.prepareStatement(sql);
                statement.setString(1, visitorId);
                statement.setString(2, data.toString());
                result = statement.executeUpdate();
                statement.close();
            }
        }
        catch (Exception e) {
            FlagshipLogManager.exception(e);
        }
        return result;
    }

    private synchronized JSONArray getHits(String visitorId) {
        JSONArray results;
        ArrayList<Integer> hitsToDelete;
        block18: {
            String sql = "SELECT * FROM hits WHERE visitorId = ?";
            hitsToDelete = new ArrayList<Integer>();
            results = new JSONArray();
            try (Connection conn = this.connect();){
                if (conn == null) break block18;
                PreparedStatement statement = conn.prepareStatement(sql);
                statement.setString(1, visitorId);
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    try {
                        results.put((Object)new JSONObject(rs.getString("content")));
                    }
                    catch (Exception e) {
                        FlagshipLogManager.exception(e);
                    }
                    hitsToDelete.add(rs.getInt("id"));
                }
                rs.close();
                statement.close();
            }
            catch (Exception e) {
                FlagshipLogManager.exception(e);
            }
        }
        if (!hitsToDelete.isEmpty()) {
            this.deleteHits(visitorId, hitsToDelete);
        }
        return results;
    }

    private synchronized int deleteHits(String visitorId) {
        int results = 0;
        String sql = "DELETE FROM hits WHERE visitorId = ?";
        try (Connection conn = this.connect();){
            if (conn != null) {
                PreparedStatement statement = conn.prepareStatement(sql);
                statement.setString(1, visitorId);
                results = statement.executeUpdate();
                statement.close();
            }
        }
        catch (SQLException e) {
            FlagshipLogManager.exception(e);
        }
        return results;
    }

    private synchronized void deleteHits(String visitorId, ArrayList<Integer> hitsId) {
        for (Integer hitId : hitsId) {
            this.deleteHit(visitorId, hitId);
        }
    }

    private synchronized int deleteHit(String visitorId, int hitId) {
        int results = 0;
        String sql = "DELETE FROM hits WHERE visitorId = ? AND id = ?";
        try (Connection conn = this.connect();){
            if (conn != null) {
                PreparedStatement statement = conn.prepareStatement(sql);
                statement.setString(1, visitorId);
                statement.setInt(2, hitId);
                results = statement.executeUpdate();
                statement.close();
            }
        }
        catch (SQLException e) {
            FlagshipLogManager.exception(e);
        }
        return results;
    }

    @Override
    public IVisitorCacheImplementation getVisitorCacheImplementation() {
        return this.cacheVisitorImplementation;
    }

    @Override
    public IHitCacheImplementation getHitCacheImplementation() {
        return this.hitCacheImplementation;
    }
}

