/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.decision;

import com.abtasty.flagship.api.IFlagshipEndpoints;
import com.abtasty.flagship.api.Response;
import com.abtasty.flagship.decision.IDecisionManager;
import com.abtasty.flagship.main.Flagship;
import com.abtasty.flagship.main.FlagshipConfig;
import com.abtasty.flagship.model.Campaign;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import java.util.ArrayList;
import org.json.JSONObject;

public abstract class DecisionManager
implements IDecisionManager,
IFlagshipEndpoints {
    protected final FlagshipConfig<?> config;
    private boolean panic = false;
    protected Flagship.StatusListener statusListener = null;

    public DecisionManager(FlagshipConfig<?> config) {
        this.config = config;
    }

    protected ArrayList<Campaign> parseCampaignsResponse(String content) {
        if (content != null && !content.isEmpty()) {
            try {
                JSONObject json = new JSONObject(content);
                this.panic = json.optBoolean("panic", false);
                this.updateFlagshipStatus(this.panic ? Flagship.Status.PANIC : Flagship.Status.READY);
                if (!this.panic) {
                    return Campaign.parse(json.getJSONArray("campaigns"));
                }
            }
            catch (Exception e) {
                FlagshipLogManager.log(FlagshipLogManager.Tag.PARSING, LogManager.Level.ERROR, "an error occurred while parsing  campaign.");
            }
        }
        return null;
    }

    protected void updateFlagshipStatus(Flagship.Status newStatus) {
        if (this.statusListener != null && Flagship.getStatus() != newStatus) {
            this.statusListener.onStatusChanged(newStatus);
        }
        if (newStatus == Flagship.Status.PANIC) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.FETCHING, LogManager.Level.WARNING, "Panic mode is enabled : all feature are disabled except synchronization.");
        }
    }

    public boolean isPanic() {
        return this.panic;
    }

    protected void logResponse(Response response) {
        String content;
        try {
            content = new JSONObject(response.getResponseContent()).toString(2);
        }
        catch (Exception e) {
            content = response.getResponseContent();
        }
        String message = String.format("[%s] %s [%d] [%dms]\n %s", new Object[]{response.getType(), response.getRequestUrl(), response.getResponseCode(), response.getResponseTime(), content});
        FlagshipLogManager.log(FlagshipLogManager.Tag.CAMPAIGNS, response.isSuccess() != false ? LogManager.Level.DEBUG : LogManager.Level.ERROR, message);
    }

    public void setStatusListener(Flagship.StatusListener statusListener) {
        this.statusListener = statusListener;
    }

    public abstract void stop();
}

