/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.hits;

import com.abtasty.flagship.hits.Hit;

public class Event
extends Hit<Event> {
    public Event(EventCategory category, String action) {
        super(Hit.Type.EVENT);
        if (category != null && action != null) {
            this.data.put("ec", (Object)category.getName());
            this.data.put("ea", (Object)action);
        }
    }

    public Event withEventLabel(String label) {
        if (label != null) {
            this.data.put("el", (Object)label);
        }
        return this;
    }

    public Event withEventValue(int value) {
        if (value > 0) {
            this.data.put("ev", value);
        }
        return this;
    }

    @Override
    public boolean checkData() {
        try {
            this.data.getString("ec");
            this.data.getString("ea");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static enum EventCategory {
        ACTION_TRACKING("Action Tracking"),
        USER_ENGAGEMENT("User Engagement");

        private String name;

        private EventCategory(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

