/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.hits;

import com.abtasty.flagship.hits.Activate;
import com.abtasty.flagship.main.Flagship;
import org.json.JSONObject;

public abstract class Hit<T> {
    private Type type;
    protected final JSONObject data = new JSONObject();

    public Hit(Type type) {
        this.type = type;
        this.data.put("cid", (Object)Flagship.getConfig().getEnvId());
        if (!(this instanceof Activate)) {
            this.data.put("t", (Object)type.toString());
            this.data.put("ds", (Object)"APP");
        }
    }

    public JSONObject getData() {
        return this.data;
    }

    public Type getType() {
        return this.type;
    }

    public abstract boolean checkData();

    public T withIp(String ip) {
        if (ip != null) {
            this.data.put("uip", (Object)ip);
        }
        return (T)this;
    }

    public T withResolution(int width, int height) {
        if (width > 0 && height > 0) {
            this.data.put("sr", (Object)String.format("%dx%d", width, height));
        }
        return (T)this;
    }

    public T withSessionNumber(int number) {
        if (number > 0) {
            this.data.put("sn", number);
        }
        return (T)this;
    }

    public T withLocale(String locale) {
        if (locale != null) {
            this.data.put("ul", (Object)locale);
        }
        return (T)this;
    }

    public String toString() {
        JSONObject json = new JSONObject();
        json.put("type", (Object)this.type);
        json.put("data", (Object)this.data);
        return json.toString(2);
    }

    static enum Type {
        SCREENVIEW,
        PAGEVIEW,
        TRANSACTION,
        ITEM,
        EVENT,
        ACTIVATION,
        BATCH,
        CONSENT;

    }
}

