/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.hits;

import com.abtasty.flagship.hits.Hit;

public class Item
extends Hit<Item> {
    public Item(String transactionId, String productName, String productSku) {
        super(Hit.Type.ITEM);
        if (transactionId != null && productName != null && productSku != null) {
            this.data.put("tid", (Object)transactionId);
            this.data.put("in", (Object)productName);
            this.data.put("ic", (Object)productSku);
        }
    }

    public Item withItemPrice(float price) {
        this.data.put("ip", price);
        return this;
    }

    public Item withItemQuantity(int quantity) {
        this.data.put("iq", quantity);
        return this;
    }

    public Item withItemCategory(String category) {
        if (category != null) {
            this.data.put("iv", (Object)category);
        }
        return this;
    }

    @Override
    public boolean checkData() {
        try {
            this.data.getString("tid");
            this.data.getString("in");
            this.data.getString("ic");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

