/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.hits;

import com.abtasty.flagship.hits.Hit;
import java.util.Currency;
import java.util.Optional;

public class Transaction
extends Hit<Transaction> {
    public Transaction(String transactionId, String affiliation) {
        super(Hit.Type.TRANSACTION);
        if (transactionId != null && affiliation != null) {
            this.data.put("tid", (Object)transactionId);
            this.data.put("ta", (Object)affiliation);
        }
    }

    public Transaction withTotalRevenue(float revenue) {
        this.data.put("tr", revenue);
        return this;
    }

    public Transaction withShippingCosts(float shipping) {
        this.data.put("ts", shipping);
        return this;
    }

    public Transaction withShippingMethod(String shippingMethod) {
        if (shippingMethod != null) {
            this.data.put("sm", (Object)shippingMethod);
        }
        return this;
    }

    public Transaction withTaxes(float taxes) {
        this.data.put("tt", taxes);
        return this;
    }

    public Transaction withCurrency(String currency) {
        if (currency != null) {
            this.data.put("tc", (Object)currency);
        }
        return this;
    }

    public Transaction withPaymentMethod(String paymentMethod) {
        if (paymentMethod != null) {
            this.data.put("pm", (Object)paymentMethod);
        }
        return this;
    }

    public Transaction withItemCount(int itemCount) {
        this.data.put("icn", itemCount);
        return this;
    }

    public Transaction withCouponCode(String coupon) {
        if (coupon != null) {
            this.data.put("tcc", (Object)coupon);
        }
        return this;
    }

    @Override
    public boolean checkData() {
        try {
            this.data.getString("tid");
            this.data.getString("ta");
            if (this.data.has("tc")) {
                String currency = this.data.getString("tc");
                Optional<Currency> result = Currency.getAvailableCurrencies().stream().filter(c -> c.getCurrencyCode().equals(currency)).findFirst();
                if (!result.isPresent()) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

