/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.main;

import com.abtasty.flagship.BuildConfig;
import com.abtasty.flagship.main.ConfigManager;
import com.abtasty.flagship.main.FlagshipConfig;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import com.abtasty.flagship.visitor.Visitor;

public class Flagship {
    private static volatile Flagship instance = null;
    private final ConfigManager configManager = new ConfigManager();
    private Visitor singleVisitorInstance = null;
    private Status status = Status.NOT_INITIALIZED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Flagship instance() {
        if (instance != null) return instance;
        Class<Flagship> clazz = Flagship.class;
        synchronized (Flagship.class) {
            if (instance != null) return instance;
            instance = new Flagship();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void start(String envId, String apiKey) {
        Flagship.start(envId, apiKey, null);
    }

    public static void start(String envId, String apiKey, FlagshipConfig<?> config) {
        Flagship.instance()._start(envId, apiKey, config);
    }

    public static Visitor.Builder newVisitor(String visitorId, Visitor.Instance instanceType) {
        return new Visitor.Builder(instanceType, Flagship.instance().configManager, visitorId);
    }

    public static Visitor.Builder newVisitor(String visitorId) {
        return Flagship.newVisitor(visitorId, Visitor.Instance.NEW_INSTANCE);
    }

    public static void setSingleVisitorInstance(Visitor visitor) {
        Flagship.instance().singleVisitorInstance = visitor;
    }

    public static Visitor getVisitor() {
        return Flagship.instance().singleVisitorInstance;
    }

    public static FlagshipConfig<?> getConfig() {
        return Flagship.instance().configManager.getFlagshipConfig();
    }

    public static Status getStatus() {
        return Flagship.instance().status;
    }

    private void _start(String envId, String apiKey, FlagshipConfig<?> config) {
        this.updateStatus(Status.STARTING);
        this.configManager.reset();
        this.configManager.init(envId, apiKey, config);
        this.configManager.getDecisionManager().setStatusListener(this::updateStatus);
        if (!this.configManager.isSet()) {
            this.updateStatus(Status.NOT_INITIALIZED);
            FlagshipLogManager.log(FlagshipLogManager.Tag.INITIALIZATION, LogManager.Level.ERROR, "Params 'envId' and 'apiKey' must not be null.");
        }
    }

    private void updateStatus(Status status) {
        if (this.status != status) {
            this.status = status;
            FlagshipLogManager.Tag tag = FlagshipLogManager.Tag.GLOBAL;
            LogManager.Level level = LogManager.Level.INFO;
            String message = this.status == Status.READY ? String.format("Flagship SDK (version: %s) READY", BuildConfig.flagship_version_name) : String.format("SDK status has changed : %s.", new Object[]{status});
            FlagshipLogManager.log(tag, level, message);
            StatusListener customerStatusListener = this.configManager.getFlagshipConfig().getStatusListener();
            if (customerStatusListener != null) {
                customerStatusListener.onStatusChanged(status);
            }
        }
    }

    public static enum Status {
        NOT_INITIALIZED(0),
        STARTING(1),
        POLLING(16),
        PANIC(32),
        READY(256);

        private final int value;

        private Status(int value) {
            this.value = value;
        }

        public boolean lessThan(Status status) {
            return this.value < status.value;
        }

        public boolean greaterThan(Status status) {
            return this.value > status.value;
        }
    }

    public static interface StatusListener {
        public void onStatusChanged(Status var1);
    }

    public static enum DecisionMode {
        API,
        BUCKETING;

    }
}

