/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.model;

import com.abtasty.flagship.model.Modification;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import java.io.Serializable;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class Modifications
implements Serializable {
    private final String campaignId;
    private final String variationGroupId;
    private final String variationId;
    private final boolean isReference;
    private final String type;
    private final HashMap<String, Modification> values;

    public Modifications(String campaignId, String variationGroupId, String variationId, boolean isReference, String type, HashMap<String, Modification> values) {
        this.campaignId = campaignId;
        this.variationGroupId = variationGroupId;
        this.variationId = variationId;
        this.isReference = isReference;
        this.type = type;
        this.values = values;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getVariationGroupId() {
        return this.variationGroupId;
    }

    public String getVariationId() {
        return this.variationId;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public String getType() {
        return this.type;
    }

    public HashMap<String, Modification> getValues() {
        return this.values;
    }

    public static Modifications parse(String campaignId, String campaignType, String slug, String variationGroupId, String variationId, boolean isReference, JSONObject modificationsObj) {
        try {
            HashMap<String, Modification> values = new HashMap<String, Modification>();
            JSONObject valueObj = modificationsObj.getJSONObject("value");
            valueObj.keySet().forEach(key -> {
                Object value;
                Object object = value = valueObj.isNull(key) ? null : valueObj.get(key);
                if (value instanceof Boolean || value instanceof Number || value instanceof String || value instanceof JSONObject || value instanceof JSONArray || value == null) {
                    values.put((String)key, new Modification((String)key, campaignId, variationGroupId, variationId, isReference, value, campaignType, slug));
                } else {
                    FlagshipLogManager.log(FlagshipLogManager.Tag.PARSING, LogManager.Level.ERROR, "an error occurred while parsing  modification.");
                }
            });
            return new Modifications(campaignId, variationGroupId, variationId, isReference, campaignType, values);
        }
        catch (Exception e) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.PARSING, LogManager.Level.ERROR, "an error occurred while parsing  modification.");
            return null;
        }
    }
}

