/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.model;

import com.abtasty.flagship.model.Targeting;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class TargetingList
implements Serializable {
    private final ArrayList<Targeting> targetingList;

    TargetingList(ArrayList<Targeting> targetingList) {
        this.targetingList = targetingList;
    }

    public static TargetingList parse(JSONObject jsonObject) {
        try {
            ArrayList<Targeting> targetingList = new ArrayList<Targeting>();
            JSONArray targetingArray = jsonObject.getJSONArray("targetings");
            for (int i = 0; i < targetingArray.length(); ++i) {
                Targeting targeting = Targeting.parse(targetingArray.getJSONObject(i));
                if (targeting == null) continue;
                targetingList.add(targeting);
            }
            return new TargetingList(targetingList);
        }
        catch (Exception e) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.PARSING, LogManager.Level.ERROR, "an error occurred while parsing  targeting.");
            return null;
        }
    }

    public ArrayList<Targeting> getTargetingList() {
        return this.targetingList;
    }

    public Boolean isTargetingValid(HashMap<String, Object> context) {
        if (this.targetingList != null) {
            for (Targeting targeting : this.targetingList) {
                if (targeting.isTargetingValid(context)) continue;
                return false;
            }
        }
        return true;
    }
}

