/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.utils;

import java.util.Random;

public class MurmurHash {
    public static int getAllocationFromMurmur(String variationGroupId, String visitorId) {
        if (variationGroupId != null && visitorId != null) {
            long hash = MurmurHash.murmurHash3_x86_32(variationGroupId + visitorId);
            return (int)(hash % 100L);
        }
        return new Random().nextInt(100);
    }

    private static long murmurHash3_x86_32(String source) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = 0;
        int pos = 0;
        int end = source.length();
        int k1 = 0;
        int k2 = 0;
        int shift = 0;
        int bits = 0;
        int nBytes = 0;
        while (pos < end) {
            int charCode;
            if ((charCode = source.charAt(pos++)) < 128) {
                k2 = charCode;
                bits = 8;
            } else if (charCode < 2048) {
                k2 = 0xC0 | charCode >> 6 | (0x80 | charCode & 0x3F) << 8;
                bits = 16;
            } else if (charCode < 55296 || charCode > 57343 || pos >= end) {
                k2 = 0xE0 | charCode >> 12 | (0x80 | charCode >> 6 & 0x3F) << 8 | (0x80 | charCode & 0x3F) << 16;
                bits = 24;
            } else {
                int utf32 = source.charAt(pos++);
                utf32 = (charCode - 55232 << 10) + (utf32 & 0x3FF);
                k2 = 0xFF & (0xF0 | utf32 >> 18) | (0x80 | utf32 >> 12 & 0x3F) << 8 | (0x80 | utf32 >> 6 & 0x3F) << 16 | (0x80 | utf32 & 0x3F) << 24;
                bits = 32;
            }
            k1 |= k2 << shift;
            if ((shift += bits) < 32) continue;
            k1 *= c1;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= c2);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
            k1 = (shift -= 32) != 0 ? k2 >>> bits - shift : 0;
            nBytes += 4;
        }
        if (shift > 0) {
            nBytes += shift >> 3;
            k1 *= c1;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= c2);
        }
        h1 ^= nBytes;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return (long)h1 & 0xFFFFFFFFL;
    }
}

