/*
 * Decompiled with CFR 0.152.
 */
package com.algorithmia.algorithm;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ReflectionHelper {
    static <T, R> String getMethodName(DebuggableFunction<T, R> debuggableFunction) {
        SerializedLambda serializedLambda = ReflectionHelper.getLambda(debuggableFunction);
        return serializedLambda.getImplMethodName();
    }

    static <T1, T2, R> String getMethodName(DebuggableBifunction<T1, T2, R> debuggableBifunction) {
        SerializedLambda serializedLambda = ReflectionHelper.getLambda(debuggableBifunction);
        return serializedLambda.getImplMethodName();
    }

    private static SerializedLambda getLambda(Serializable serializable) {
        for (Class<?> clazz = serializable.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Method method = clazz.getDeclaredMethod("writeReplace", new Class[0]);
                method.setAccessible(true);
                Object object = method.invoke((Object)serializable, new Object[0]);
                if (object instanceof SerializedLambda) {
                    SerializedLambda serializedLambda = (SerializedLambda)object;
                    return serializedLambda;
                }
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new RuntimeException("The writeReplace method implemented by your algorithm class is incompatible with this framework", reflectiveOperationException);
            }
        }
        throw new RuntimeException("We were unable to find a Serializable form of your method reference. Please ensure that you're using a compatible version of java.");
    }

    @FunctionalInterface
    public static interface DebuggableBifunction<T1, T2, R>
    extends Serializable,
    BiFunction<T1, T2, R> {
    }

    @FunctionalInterface
    public static interface DebuggableFunction<T, R>
    extends Serializable,
    Function<T, R> {
    }
}

