/*
 * Decompiled with CFR 0.152.
 */
package com.algorithmia.development;

import com.algorithmia.development.AbstractAlgorithm;
import com.algorithmia.development.FindApply;
import com.algorithmia.development.RequestHandler;
import com.algorithmia.development.ResponseHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotationUtils;

public class ADK<INPUT, OUTPUT> {
    private AbstractAlgorithm<INPUT, OUTPUT> implementation;
    private RequestHandler<INPUT> in;
    private String FIFO_PATH = "/tmp/algoout";
    private ResponseHandler out = new ResponseHandler(this.FIFO_PATH);
    private RuntimeException loadingException;
    private Boolean is_local;

    public ADK(AbstractAlgorithm<INPUT, OUTPUT> abstractAlgorithm) {
        this.implementation = abstractAlgorithm;
        this.is_local = new File(this.FIFO_PATH).exists() ? Boolean.valueOf(false) : Boolean.valueOf(true);
        Class<INPUT> clazz = this.getInputClass(abstractAlgorithm);
        this.in = new RequestHandler<INPUT>(clazz);
    }

    private void load() {
        try {
            this.implementation.load();
            System.out.println("PIPE_INIT_COMPLETE");
            System.out.flush();
        }
        catch (RuntimeException runtimeException) {
            this.loadingException = runtimeException;
        }
    }

    private Class<INPUT> getInputClass(AbstractAlgorithm<INPUT, OUTPUT> abstractAlgorithm) {
        Method[] methodArray = abstractAlgorithm.getClass().getMethods();
        Class<?> clazz = null;
        for (Method method : methodArray) {
            if (AnnotationUtils.findAnnotation((Method)method, FindApply.class) == null) continue;
            clazz = method.getParameterTypes()[0];
            if (method.getReturnType() == Object.class) continue;
            return clazz;
        }
        if (clazz != null) {
            return clazz;
        }
        throw new RuntimeException("Unable to find the 'public' method reference called 'apply' in the provided class.");
    }

    public void init() {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));){
            Stream<String> stream = bufferedReader.lines();
            this.load();
            stream.forEach(string -> {
                if (this.loadingException != null) {
                    this.out.writeErrorToPipe(this.loadingException, false);
                } else {
                    try {
                        INPUT INPUT = this.in.processRequest((String)string);
                        OUTPUT OUTPUT = this.implementation.apply(INPUT);
                        this.out.writeToPipe(OUTPUT, false);
                    }
                    catch (RuntimeException runtimeException) {
                        this.out.writeErrorToPipe(runtimeException, false);
                    }
                }
            });
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void init(INPUT INPUT) {
        this.load();
        if (this.is_local.booleanValue()) {
            try {
                OUTPUT OUTPUT = this.implementation.apply(INPUT);
                this.out.writeToPipe(OUTPUT, true);
            }
            catch (RuntimeException runtimeException) {
                this.out.writeErrorToPipe(runtimeException, true);
            }
        } else {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));){
                Stream<String> stream = bufferedReader.lines();
                stream.forEach(string -> {
                    if (this.loadingException != null) {
                        this.out.writeErrorToPipe(this.loadingException, false);
                    } else {
                        try {
                            INPUT INPUT = this.in.processRequest((String)string);
                            OUTPUT OUTPUT = this.implementation.apply(INPUT);
                            this.out.writeToPipe(OUTPUT, false);
                        }
                        catch (RuntimeException runtimeException) {
                            this.out.writeErrorToPipe(runtimeException, false);
                        }
                    }
                });
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

