/*
 * Decompiled with CFR 0.152.
 */
package com.algorithmia.development;

import com.algorithmia.development.BetterDeserialization;
import com.algorithmia.development.Request;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import org.apache.commons.codec.binary.Base64;

class RequestHandler<ALGO_INPUT> {
    private JsonParser parser = new JsonParser();
    private Gson gson;
    private Class<ALGO_INPUT> inputClass;

    RequestHandler(Class<ALGO_INPUT> clazz) {
        this.inputClass = clazz;
        this.gson = new GsonBuilder().registerTypeAdapter(clazz, new BetterDeserialization()).create();
    }

    private ALGO_INPUT convertToType(Request request) {
        try {
            if (this.inputClass == byte[].class) {
                return this.inputClass.cast(Base64.decodeBase64((String)request.data.getAsString()));
            }
            if (this.inputClass == JsonElement.class) {
                return this.inputClass.cast(request.data);
            }
            if (this.inputClass == String.class) {
                return this.inputClass.cast(request.data.getAsString());
            }
            if (this.inputClass == Number.class) {
                return this.inputClass.cast(request.data.getAsNumber());
            }
            return (ALGO_INPUT)this.gson.fromJson(request.data, this.inputClass);
        }
        catch (Throwable throwable) {
            String string = this.inputClass.getName();
            String string2 = request.data.toString();
            throw new RuntimeException("unable to parse data: " + string2 + " as expected type: " + string, throwable);
        }
    }

    ALGO_INPUT processRequest(String string) {
        try {
            JsonObject jsonObject = this.parser.parse(string).getAsJsonObject();
            String string2 = jsonObject.get("content_type").getAsString();
            JsonElement jsonElement = jsonObject.get("data");
            Request request = new Request(string2, jsonElement);
            ALGO_INPUT ALGO_INPUT = this.convertToType(request);
            return ALGO_INPUT;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            throw new RuntimeException(jsonSyntaxException);
        }
    }
}

