/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.impl.unicode;

import com.antgroup.antchain.myjava.classlib.impl.unicode.UnicodeHelper;
import com.antgroup.antchain.myjava.common.IntegerArray;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public final class UnicodeSupport {
    private static AtomicBoolean filled = new AtomicBoolean();
    private static volatile CountDownLatch latch = new CountDownLatch(1);
    private static int[] digitValues;
    private static byte[] classes;
    private static int[] titleCaseMapping;
    private static Map<String, Byte> classMap;

    private UnicodeSupport() {
    }

    private static void parseUnicodeData() {
        int i;
        IntegerArray digitValues = new IntegerArray(4096);
        IntegerArray classes = new IntegerArray(65536);
        IntegerArray titleCaseMapping = new IntegerArray(256);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(UnicodeHelper.class.getResourceAsStream("UnicodeData.txt")));){
            String line;
            while ((line = reader.readLine()) != null) {
                Byte charClass;
                if (line.isEmpty()) continue;
                String[] fields = UnicodeSupport.splitLine(line);
                int charCode = UnicodeSupport.parseHex(fields[0]);
                while (classes.size() < charCode) {
                    classes.add(0);
                }
                if (!fields[6].isEmpty()) {
                    int digit = Integer.parseInt(fields[6]);
                    digitValues.add(charCode);
                    digitValues.add(digit);
                }
                classes.add((charClass = classMap.get(fields[2])) != null ? charClass.intValue() : 0);
                if (fields[14].isEmpty()) continue;
                int titleCaseCode = UnicodeSupport.parseHex(fields[14]);
                if (!fields[12].isEmpty() && UnicodeSupport.parseHex(fields[12]) == titleCaseCode) continue;
                titleCaseMapping.add(charCode);
                titleCaseMapping.add(titleCaseCode);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading unicode data", e);
        }
        IntegerArray letterDigitValues = new IntegerArray(256);
        for (i = 65; i <= 90; ++i) {
            letterDigitValues.add(i);
            letterDigitValues.add(i - 65 + 10);
        }
        for (i = 97; i <= 122; ++i) {
            letterDigitValues.add(i);
            letterDigitValues.add(i - 97 + 10);
        }
        for (i = 65313; i <= 65338; ++i) {
            letterDigitValues.add(i);
            letterDigitValues.add(i - 65313 + 10);
        }
        for (i = 65345; i <= 65370; ++i) {
            letterDigitValues.add(i);
            letterDigitValues.add(i - 65345 + 10);
        }
        UnicodeSupport.digitValues = UnicodeSupport.mergePairs(digitValues.getAll(), letterDigitValues.getAll());
        UnicodeSupport.classes = new byte[classes.size()];
        for (i = 0; i < classes.size(); ++i) {
            UnicodeSupport.classes[i] = (byte)classes.get(i);
        }
        UnicodeSupport.titleCaseMapping = titleCaseMapping.getAll();
    }

    private static String[] splitLine(String line) {
        int next;
        ArrayList<String> parts = new ArrayList<String>();
        int index = 0;
        while ((next = line.indexOf(59, index)) != -1) {
            parts.add(line.substring(index, next));
            index = next + 1;
        }
        parts.add(line.substring(index));
        return parts.toArray(new String[parts.size()]);
    }

    private static int[] mergePairs(int[] a, int[] b) {
        int[] result = new int[a.length + b.length];
        int i = 0;
        int j = 0;
        int t = 0;
        while (true) {
            if (j == b.length) {
                while (i < a.length) {
                    result[t++] = a[i++];
                }
                break;
            }
            if (i == a.length) {
                while (j < b.length) {
                    result[t++] = b[j++];
                }
                break;
            }
            if (a[i] < b[j]) {
                result[t++] = a[i++];
                result[t++] = a[i++];
                continue;
            }
            result[t++] = b[j++];
            result[t++] = b[j++];
        }
        return result;
    }

    private static int parseHex(String text) {
        int value = 0;
        for (int i = 0; i < text.length(); ++i) {
            value = value << 4 | UnicodeHelper.valueOfHexDigit(text.charAt(i));
        }
        return value;
    }

    private static void ensureUnicodeData() {
        if (filled.compareAndSet(false, true)) {
            UnicodeSupport.parseUnicodeData();
            latch.countDown();
            latch = null;
        } else {
            CountDownLatch latchCopy = latch;
            if (latchCopy != null) {
                try {
                    latchCopy.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    public static int[] getDigitValues() {
        UnicodeSupport.ensureUnicodeData();
        return digitValues;
    }

    public static byte[] getClasses() {
        UnicodeSupport.ensureUnicodeData();
        return classes;
    }

    public static int[] getTitleCaseMapping() {
        UnicodeSupport.ensureUnicodeData();
        return titleCaseMapping;
    }

    static {
        classMap = new HashMap<String, Byte>();
        classMap.put("Cn", (byte)0);
        classMap.put("Lu", (byte)1);
        classMap.put("Ll", (byte)2);
        classMap.put("Lt", (byte)3);
        classMap.put("Lm", (byte)4);
        classMap.put("Lo", (byte)5);
        classMap.put("Mn", (byte)6);
        classMap.put("Me", (byte)7);
        classMap.put("Mc", (byte)8);
        classMap.put("Nd", (byte)9);
        classMap.put("Nl", (byte)10);
        classMap.put("No", (byte)11);
        classMap.put("Zs", (byte)12);
        classMap.put("Zl", (byte)13);
        classMap.put("Zp", (byte)14);
        classMap.put("Cc", (byte)15);
        classMap.put("Cf", (byte)16);
        classMap.put("Co", (byte)18);
        classMap.put("Cs", (byte)19);
        classMap.put("Pd", (byte)20);
        classMap.put("Ps", (byte)21);
        classMap.put("Pe", (byte)22);
        classMap.put("Pc", (byte)23);
        classMap.put("Po", (byte)24);
        classMap.put("Sm", (byte)25);
        classMap.put("Sc", (byte)26);
        classMap.put("Sk", (byte)27);
        classMap.put("So", (byte)28);
        classMap.put("Pi", (byte)29);
        classMap.put("Pf", (byte)30);
    }
}

