/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.lang;

import com.antgroup.antchain.myjava.classlib.impl.IntegerUtil;
import com.antgroup.antchain.myjava.classlib.java.lang.TAbstractStringBuilder;
import com.antgroup.antchain.myjava.classlib.java.lang.TCharacter;
import com.antgroup.antchain.myjava.classlib.java.lang.TComparable;
import com.antgroup.antchain.myjava.classlib.java.lang.TNumber;
import com.antgroup.antchain.myjava.classlib.java.lang.TNumberFormatException;
import com.antgroup.antchain.myjava.classlib.java.lang.TString;
import com.antgroup.antchain.myjava.classlib.java.lang.TSystem;
import com.antgroup.antchain.myjava.interop.NoInitClass;
import com.antgroup.antchain.myjava.interop.NoSideEffects;
import com.antgroup.antchain.myjava.interop.Unmanaged;
import com.antgroup.antchain.myjava.runtime.PrimitiveAlgoUtil;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;

public class TInteger
extends TNumber
implements TComparable<TInteger> {
    public static final int SIZE = 32;
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final Class<Integer> TYPE = Integer.TYPE;
    private static TInteger[] integerCache;
    private int value;

    public TInteger(int value) {
        this.value = value;
    }

    public TInteger(String s) throws NumberFormatException {
        this(TInteger.parseInt(s));
    }

    public static String toString(int i, int radix) {
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        return new TAbstractStringBuilder(20).append(i, radix).toString();
    }

    public static int hashCode(int value) {
        return value >>> 4 ^ value << 28 ^ value << 8 ^ value >>> 24;
    }

    public static String toHexString(int i) {
        if (i == (i & 0xFF)) {
            char[] chars = PrimitiveAlgoUtil.toHexStringFromByte((byte)((byte)(i & 0xFF)));
            return new String(chars);
        }
        return IntegerUtil.toUnsignedLogRadixString(i, 4);
    }

    public static String toOctalString(int i) {
        return IntegerUtil.toUnsignedLogRadixString(i, 3);
    }

    public static String toBinaryString(int i) {
        return IntegerUtil.toUnsignedLogRadixString(i, 1);
    }

    public static String toString(int i) {
        return TInteger.toString(i, 10);
    }

    public static int parseInt(String s, int radix) throws TNumberFormatException {
        if (radix < 2 || radix > 36) {
            throw new TNumberFormatException("Illegal radix: " + radix);
        }
        if (s == null || s.isEmpty()) {
            throw new TNumberFormatException("String is null or empty");
        }
        boolean negative = false;
        int index = 0;
        switch (s.charAt(0)) {
            case '-': {
                negative = true;
                index = 1;
                break;
            }
            case '+': {
                index = 1;
            }
        }
        int value = 0;
        if (index == s.length()) {
            throw new TNumberFormatException();
        }
        while (index < s.length()) {
            int digit;
            if ((digit = TCharacter.getNumericValue(s.charAt(index++))) < 0) {
                throw new TNumberFormatException("String contains invalid digits: " + s);
            }
            if (digit >= radix) {
                throw new TNumberFormatException("String contains digits out of radix " + radix + ": " + s);
            }
            if ((value = radix * value + digit) >= 0) continue;
            if (index == s.length() && value == Integer.MIN_VALUE && negative) {
                return Integer.MIN_VALUE;
            }
            throw new TNumberFormatException("The value is too big for int type: " + s);
        }
        return negative ? -value : value;
    }

    public static int parseInt(String s) throws TNumberFormatException {
        return TInteger.parseInt(s, 10);
    }

    public static TInteger valueOf(String s, int radix) throws TNumberFormatException {
        return TInteger.valueOf(TInteger.parseInt(s, radix));
    }

    public static TInteger valueOf(String s) throws TNumberFormatException {
        return TInteger.valueOf(s, 10);
    }

    public static TInteger valueOf(int i) {
        if (i >= -128 && i <= 127) {
            TInteger.ensureIntegerCache();
            return integerCache[i + 128];
        }
        return new TInteger(i);
    }

    private static void ensureIntegerCache() {
        if (integerCache == null) {
            integerCache = new TInteger[256];
            for (int j = 0; j < integerCache.length; ++j) {
                TInteger.integerCache[j] = new TInteger(j - 128);
            }
        }
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return TInteger.toString(this.value);
    }

    @Override
    public int hashCode() {
        return TInteger.hashCode(this.value);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TInteger && ((TInteger)other).value == this.value;
    }

    public static TInteger getInteger(TString nm) {
        return TInteger.getInteger(nm, null);
    }

    public static TInteger getInteger(TString nm, int val) {
        return TInteger.getInteger(nm, TInteger.valueOf(val));
    }

    public static TInteger getInteger(TString nm, TInteger val) {
        String result = nm != null ? TSystem.getProperty(nm.toString()) : null;
        try {
            return result != null ? TInteger.valueOf(result) : val;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static TInteger decode(String nm) throws TNumberFormatException {
        if (nm == null || nm.isEmpty()) {
            throw new TNumberFormatException("Can't parse empty or null string");
        }
        int index = 0;
        boolean negaive = false;
        if (nm.charAt(index) == '+') {
            ++index;
        } else if (nm.charAt(index) == '-') {
            ++index;
            negaive = true;
        }
        if (index >= nm.length()) {
            throw new TNumberFormatException("The string does not represent a number");
        }
        int radix = 10;
        if (nm.charAt(index) == '#') {
            radix = 16;
            ++index;
        } else if (nm.charAt(index) == '0') {
            if (++index == nm.length()) {
                return TInteger.valueOf(0);
            }
            if (nm.charAt(index) == 'x' || nm.charAt(index) == 'X') {
                radix = 16;
                ++index;
            } else {
                radix = 8;
            }
        }
        if (index >= nm.length()) {
            throw new TNumberFormatException("The string does not represent a number");
        }
        int value = 0;
        while (index < nm.length()) {
            int digit;
            if ((digit = TInteger.decodeDigit(nm.charAt(index++))) >= radix) {
                throw new TNumberFormatException("The string does not represent a number");
            }
            if ((value = value * radix + digit) >= 0) continue;
            if (negaive && value == Integer.MIN_VALUE && index == nm.length()) {
                return TInteger.valueOf(Integer.MIN_VALUE);
            }
            throw new TNumberFormatException("The string represents a too big number");
        }
        return TInteger.valueOf(negaive ? -value : value);
    }

    private static int decodeDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65 + 10;
        }
        return 255;
    }

    @Override
    public int compareTo(TInteger other) {
        return TInteger.compare(this.value, other.value);
    }

    @NoSideEffects
    public static native int compare(int var0, int var1);

    @NoSideEffects
    @Unmanaged
    @NoInitClass
    public static int numberOfLeadingZeros(int i) {
        return WasmRuntime.numberOfLeadingZerosOfInt32((int)i);
    }

    @NoSideEffects
    @Unmanaged
    @NoInitClass
    public static int numberOfTrailingZeros(int i) {
        return WasmRuntime.numberOfTrailingZerosOfInt32((int)i);
    }

    public static int highestOneBit(int i) {
        return Integer.MIN_VALUE >>> TInteger.numberOfLeadingZeros(i);
    }

    public static int lowestOneBit(int i) {
        return 1 << TInteger.numberOfTrailingZeros(i);
    }

    @NoSideEffects
    @Unmanaged
    @NoInitClass
    public static int bitCount(int i) {
        return WasmRuntime.bigCountOfInt32((int)i);
    }

    @NoSideEffects
    @Unmanaged
    public static int rotateLeft(int i, int distance) {
        return WasmRuntime.rotateLeftOfInt32((int)i, (int)distance);
    }

    @NoSideEffects
    @Unmanaged
    public static int rotateRight(int i, int distance) {
        return WasmRuntime.rotateRightOfInt32((int)i, (int)distance);
    }

    public static int reverse(int i) {
        i = (i & 0xAAAAAAAA) >>> 1 | (i & 0x55555555) << 1;
        i = (i & 0xCCCCCCCC) >>> 2 | (i & 0x33333333) << 2;
        i = (i & 0xF0F0F0F0) >>> 4 | (i & 0xF0F0F0F) << 4;
        i = (i & 0xFF00FF00) >>> 8 | (i & 0xFF00FF) << 8;
        i = (i & 0xFFFF0000) >>> 16 | (i & 0xFFFF) << 16;
        return i;
    }

    public static int reverseBytes(int i) {
        i = (i & 0xFF00FF00) >>> 8 | (i & 0xFF00FF) << 8;
        i = (i >>> 16) + (i << 16);
        return i;
    }

    public static int signum(int i) {
        return i >> 31 | -i >>> 31;
    }

    public static int divideUnsigned(int dividend, int divisor) {
        if (divisor == 0) {
            throw new RuntimeException("divide zero");
        }
        return dividend / divisor;
    }

    public static int remainderUnsigned(int dividend, int divisor) {
        if (divisor == 0) {
            throw new RuntimeException("divide zero");
        }
        return dividend % divisor;
    }
}

