/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.lang;

import com.antgroup.antchain.myjava.classlib.java.lang.TDouble;
import com.antgroup.antchain.myjava.classlib.java.lang.TFloat;
import com.antgroup.antchain.myjava.classlib.java.lang.TObject;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjava.interop.NoSideEffects;
import com.antgroup.antchain.myjava.interop.Unmanaged;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;

@NoSideEffects
@NoMetadata
public final class TMath
extends TObject {
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    private static final double ONE_OVER_LOG = 1.4426950408889634;
    private static final double LOG_EPSILON = 1.0E-7;
    private static final double SQRT_PRECISION = 1.0E-6;

    private TMath() {
    }

    public static double sin(double a) {
        throw new RuntimeException("not supported Math.sign");
    }

    public static double cos(double a) {
        throw new RuntimeException("not supported Math.cos");
    }

    public static double tan(double a) {
        throw new RuntimeException("not supported Math.tan");
    }

    public static double asin(double a) {
        throw new RuntimeException("not supported Math.asin");
    }

    public static double acos(double a) {
        throw new RuntimeException("not supported Math.acos");
    }

    public static double atan(double a) {
        throw new RuntimeException("not supported Math.atan");
    }

    public static double toRadians(double angdeg) {
        return angdeg * Math.PI / 180.0;
    }

    public static double toDegrees(double angrad) {
        return angrad * 180.0 / Math.PI;
    }

    public static double exp(double a) {
        long tmp = (long)(1512775.0 * a + 1.072632447E9);
        return Double.longBitsToDouble(tmp << 32);
    }

    public static double log(double a) {
        return TMath.logImpl(a);
    }

    public static double logImpl(double a) {
        throw new RuntimeException("Math.log not supported now");
    }

    public static double log2(double a) {
        throw new RuntimeException("Math.log not supported now");
    }

    public static double log10(double a) {
        double log2Of10 = TMath.log2(10.0);
        return TMath.log2(a) / log2Of10;
    }

    public static int log10Int(double x) {
        if (x < 10.0) {
            return 0;
        }
        return 1 + TMath.log10Int(x / 10.0);
    }

    private static double sqrt(double X, double low, double high) {
        double mid = (low + high) / 2.0;
        double p = mid * mid;
        if (p == X || Math.abs(X - p) < 1.0E-6) {
            return mid;
        }
        if (p < X) {
            return TMath.sqrt(X, mid, high);
        }
        return TMath.sqrt(X, low, mid);
    }

    @NoSideEffects
    @Unmanaged
    public static double sqrt(double a) {
        return WasmRuntime.sqrtOfFloat64((double)a);
    }

    public static double cbrt(double a) {
        return a > 0.0 ? TMath.pow(a, 0.3333333333333333) : -TMath.pow(-a, 0.3333333333333333);
    }

    public static double IEEEremainder(double f1, double f2) {
        int n = (int)(f1 / f2);
        return f1 - (double)n * f2;
    }

    @NoSideEffects
    @Unmanaged
    public static double ceil(double a) {
        return WasmRuntime.ceilOfFloat64((double)a);
    }

    @NoSideEffects
    @Unmanaged
    public static double floor(double a) {
        return WasmRuntime.floorOfFloat64((double)a);
    }

    private static double powInt(double x, int y) {
        if (x == 0.0) {
            return 0.0;
        }
        if (y == 0) {
            return 1.0;
        }
        if (y == 1) {
            return x;
        }
        boolean aMinus = x < 0.0;
        boolean bMinus = y < 0;
        int bAbs = TMath.abs(y);
        double aAbs = TMath.abs(x);
        double tempAnswer = (y & 1) != 0 ? TMath.powInt(aAbs, bAbs - 1) * aAbs : TMath.powInt(aAbs * aAbs, bAbs / 2);
        if (bMinus) {
            tempAnswer = 1.0 / tempAnswer;
        }
        if (aMinus && (y & 1) != 0) {
            tempAnswer *= -1.0;
        }
        return tempAnswer;
    }

    public static double pow(double x, double y) {
        int intY = (int)TMath.round(y);
        return TMath.powInt(x, intY);
    }

    public static double rint(double a) {
        double aDecimal = a % 1.0;
        if (TMath.abs(aDecimal - 0.5) < 1.0E-5 || TMath.abs(aDecimal + 0.5) < 1.0E-5) {
            int a1 = (int)TMath.floor(a);
            int a2 = a1 + 1;
            if (a1 % 2 == 0) {
                return a1;
            }
            return a2;
        }
        return TMath.round(a);
    }

    public static double atan2(double y, double x) {
        throw new RuntimeException("not supported Math.atan2");
    }

    public static int round(float a) {
        return (int)(a + TMath.signum(a) * 0.5f);
    }

    public static long round(double a) {
        if (a == 0.0) {
            return 0L;
        }
        double b = a + TMath.signum(a) * 0.5;
        long c = (long)b;
        if (a < 0.0 && (double)c <= TMath.floor(b)) {
            return c + 1L;
        }
        return c;
    }

    public static int floorDiv(int a, int b) {
        int div = a / b;
        return (a ^ b) < 0 && div * b != a ? div - 1 : div;
    }

    public static long floorDiv(long a, int b) {
        return TMath.floorDiv(a, (long)b);
    }

    public static long floorDiv(long a, long b) {
        long div = a / b;
        return (a ^ b) < 0L && div * b != a ? div - 1L : div;
    }

    public static int floorMod(int a, int b) {
        return a - TMath.floorDiv(a, b) * b;
    }

    public static int floorMod(long a, int b) {
        return (int)(a - TMath.floorDiv(a, b) * (long)b);
    }

    public static long floorMod(long a, long b) {
        return a - TMath.floorDiv(a, b) * b;
    }

    public static double random() {
        throw new RuntimeException("not supported Math.random");
    }

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static long min(long a, long b) {
        return a < b ? a : b;
    }

    public static long max(long a, long b) {
        return a > b ? a : b;
    }

    @NoSideEffects
    @Unmanaged
    public static double min(double a, double b) {
        return WasmRuntime.minOfFloat64((double)a, (double)b);
    }

    @NoSideEffects
    @Unmanaged
    public static double max(double a, double b) {
        return WasmRuntime.maxOfFloat64((double)a, (double)b);
    }

    @NoSideEffects
    @Unmanaged
    public static float min(float a, float b) {
        return WasmRuntime.minOfFloat32((float)a, (float)b);
    }

    @NoSideEffects
    @Unmanaged
    public static float max(float a, float b) {
        return WasmRuntime.maxOfFloat32((float)a, (float)b);
    }

    public static int abs(int n) {
        return n > 0 ? n : -n;
    }

    public static long abs(long n) {
        return n > 0L ? n : -n;
    }

    @NoSideEffects
    @Unmanaged
    public static float abs(float n) {
        return WasmRuntime.absOfFloat32((float)n);
    }

    @NoSideEffects
    @Unmanaged
    public static double abs(double n) {
        return WasmRuntime.absOfFloat64((double)n);
    }

    public static double ulp(double d) {
        if (TDouble.isNaN(d)) {
            return d;
        }
        if (TDouble.isInfinite(d)) {
            return Double.POSITIVE_INFINITY;
        }
        if (TDouble.isNaN(d)) {
            return d;
        }
        if (TDouble.isInfinite(d)) {
            return Double.POSITIVE_INFINITY;
        }
        if (0.0 == d) {
            return Double.MIN_VALUE;
        }
        long bits = TDouble.doubleToLongBits(d);
        if ((bits &= 0xEFF0000000000000L) >= 0x350000000000000L) {
            bits -= 0x340000000000000L;
        } else {
            int exponent = (int)(bits >> 52);
            bits = 1 << Math.max(0, exponent - 1);
        }
        return TDouble.longBitsToDouble(bits);
    }

    public static float ulp(float d) {
        if (TFloat.isNaN(d)) {
            return d;
        }
        if (TFloat.isInfinite(d)) {
            return Float.POSITIVE_INFINITY;
        }
        if (0.0f == d) {
            return Float.MIN_NORMAL;
        }
        int bits = TFloat.floatToIntBits(d);
        if ((long)(bits &= 0x7F800000) >= 0xC000000L) {
            bits = (int)((long)bits - 0xB800000L);
        } else {
            int exponent = bits >> 23;
            bits = 1 << Math.max(0, exponent - 1);
        }
        return TFloat.intBitsToFloat(bits);
    }

    public static double signum(double d) {
        return d > 0.0 ? 1.0 : (d < 0.0 ? -1.0 : d);
    }

    public static float signum(float d) {
        return d > 0.0f ? 1.0f : (d < 0.0f ? -1.0f : d);
    }

    public static double sinh(double x) {
        double e = TMath.exp(x);
        return (e - 1.0 / e) / 2.0;
    }

    public static double cosh(double x) {
        double e = TMath.exp(x);
        return (e + 1.0 / e) / 2.0;
    }

    public static double tanh(double x) {
        double e = TMath.exp(x);
        return (e - 1.0 / e) / (e + 1.0 / e);
    }

    public static double hypot(double x, double y) {
        return TMath.sqrt(x * x + y * y);
    }

    public static double expm1(double x) {
        return TMath.exp(x) - 1.0;
    }

    public static double log1p(double x) {
        return TMath.log(x + 1.0);
    }

    @NoSideEffects
    @Unmanaged
    public static float copySign(float magnitude, float sign) {
        return WasmRuntime.copySignOfFloat32((float)magnitude, (float)sign);
    }

    @NoSideEffects
    @Unmanaged
    public static double copySign(double magnitude, double sign) {
        return WasmRuntime.copySignOfFloat64((double)magnitude, (double)sign);
    }

    public static int getExponent(double d) {
        long bits = TDouble.doubleToLongBits(d);
        int exponent = (int)(bits >> 52 & 0x7FFL);
        return exponent - 1023;
    }

    public static int getExponent(float f) {
        int bits = TFloat.floatToIntBits(f);
        int exponent = bits >> 23 & 0xF;
        return exponent + 128;
    }

    public static double nextAfter(double start, double direction) {
        if (start == direction) {
            return direction;
        }
        return direction > start ? TMath.nextUp(start) : TMath.nextDown(start);
    }

    public static float nextAfter(float start, double direction) {
        if ((double)start == direction) {
            return start;
        }
        return direction > (double)start ? TMath.nextUp(start) : TMath.nextDown(start);
    }

    public static double nextUp(double d) {
        boolean negative;
        if (TDouble.isNaN(d)) {
            return d;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return d;
        }
        long bits = TDouble.doubleToLongBits(d);
        boolean bl = negative = (bits & Long.MIN_VALUE) != 0L;
        bits = negative ? --bits : ++bits;
        return TDouble.longBitsToDouble(bits);
    }

    public static float nextUp(float d) {
        boolean negative;
        if (TFloat.isNaN(d)) {
            return d;
        }
        if (d == Float.POSITIVE_INFINITY) {
            return d;
        }
        int bits = TFloat.floatToIntBits(d);
        boolean bl = negative = ((long)bits & 0x80000000L) != 0L;
        bits = negative ? --bits : ++bits;
        return TFloat.intBitsToFloat(bits);
    }

    public static double nextDown(double d) {
        boolean negative;
        if (TDouble.isNaN(d)) {
            return d;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        long bits = TDouble.doubleToLongBits(d);
        boolean bl = negative = (bits & Long.MIN_VALUE) != 0L;
        bits = negative ? ++bits : --bits;
        return TDouble.longBitsToDouble(bits);
    }

    public static float nextDown(float d) {
        boolean negative;
        if (TFloat.isNaN(d)) {
            return d;
        }
        if (d == Float.POSITIVE_INFINITY) {
            return d;
        }
        int bits = TFloat.floatToIntBits(d);
        boolean bl = negative = ((long)bits & 0x80000000L) != 0L;
        bits = negative ? ++bits : --bits;
        return TFloat.intBitsToFloat(bits);
    }
}

