/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.lang.reflect;

import com.antgroup.antchain.myjava.dependency.DependencyAgent;
import com.antgroup.antchain.myjava.dependency.DependencyPlugin;
import com.antgroup.antchain.myjava.dependency.MethodDependency;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ValueType;
import java.util.HashSet;
import java.util.Set;

public class ArrayNativeGenerator
implements DependencyPlugin {
    private static final String[] primitives = new String[]{"Byte", "Short", "Char", "Int", "Long", "Float", "Double", "Boolean"};
    private static final String[] primitiveWrappers = new String[]{"Byte", "Short", "Character", "Integer", "Long", "Float", "Double", "Boolean"};
    private static final ValueType[] primitiveTypes = new ValueType[]{ValueType.BYTE, ValueType.SHORT, ValueType.CHARACTER, ValueType.INTEGER, ValueType.LONG, ValueType.FLOAT, ValueType.DOUBLE, ValueType.BOOLEAN};
    private Set<MethodReference> reachedMethods = new HashSet<MethodReference>();

    public void methodReached(DependencyAgent agent, MethodDependency method) {
        if (!this.reachedMethods.add(method.getReference())) {
            return;
        }
        switch (method.getReference().getName()) {
            case "getLength": {
                this.reachGetLength(agent, method);
                break;
            }
            case "newInstance": {
                method.getVariable(1).getClassValueNode().addConsumer(t -> {
                    String arrayTypeName = t.getName().startsWith("[") ? t.getName() : (t.getName().startsWith("~") ? t.getName().substring(1) : ValueType.object((String)t.getName()).toString());
                    if (!arrayTypeName.startsWith("[[[")) {
                        method.getResult().propagate(agent.getType("[" + arrayTypeName));
                    }
                });
                break;
            }
            case "getImpl": {
                this.reachGet(agent, method);
                break;
            }
            case "setImpl": {
                this.reachSet(agent, method);
            }
        }
    }

    private void reachGetLength(DependencyAgent agent, MethodDependency method) {
        method.getVariable(1).addConsumer(type -> {
            if (!type.getName().startsWith("[")) {
                MethodReference cons = new MethodReference(IllegalArgumentException.class, "<init>", new Class[]{Void.TYPE});
                agent.linkMethod(cons).use();
            }
        });
    }

    private void reachGet(DependencyAgent agent, MethodDependency method) {
        method.getVariable(1).getArrayItem().connect(method.getResult());
        method.getVariable(1).addConsumer(type -> {
            if (type.getName().startsWith("[")) {
                String typeName = type.getName().substring(1);
                for (int i = 0; i < primitiveTypes.length; ++i) {
                    if (!primitiveTypes[i].toString().equals(typeName)) continue;
                    String wrapper = "java.lang." + primitiveWrappers[i];
                    MethodReference methodRef = new MethodReference(wrapper, "valueOf", new ValueType[]{primitiveTypes[i], ValueType.object((String)wrapper)});
                    agent.linkMethod(methodRef).use();
                    method.getResult().propagate(agent.getType("java.lang." + primitiveWrappers[i]));
                }
            }
        });
    }

    private void reachSet(DependencyAgent agent, MethodDependency method) {
        method.getVariable(3).connect(method.getVariable(1).getArrayItem());
        method.getVariable(1).addConsumer(type -> {
            if (type.getName().startsWith("[")) {
                String typeName = type.getName().substring(1);
                for (int i = 0; i < primitiveTypes.length; ++i) {
                    if (!primitiveTypes[i].toString().equals(typeName)) continue;
                    String wrapper = "java.lang." + primitiveWrappers[i];
                    MethodReference methodRef = new MethodReference(wrapper, primitives[i].toLowerCase() + "Value", new ValueType[]{primitiveTypes[i]});
                    agent.linkMethod(methodRef).use();
                }
            }
        });
    }
}

