/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.lang.reflect;

import com.antgroup.antchain.myjava.classlib.java.lang.TArrayIndexOutOfBoundsException;
import com.antgroup.antchain.myjava.classlib.java.lang.TClass;
import com.antgroup.antchain.myjava.classlib.java.lang.TIllegalArgumentException;
import com.antgroup.antchain.myjava.classlib.java.lang.TNegativeArraySizeException;
import com.antgroup.antchain.myjava.classlib.java.lang.TNullPointerException;
import com.antgroup.antchain.myjava.classlib.java.lang.TObject;
import com.antgroup.antchain.myjava.classlib.java.lang.reflect.ArrayNativeGenerator;
import com.antgroup.antchain.myjava.classlib.java.lang.reflect.TMethod;
import com.antgroup.antchain.myjava.dependency.PluggableDependency;
import com.antgroup.antchain.myjava.interop.Address;
import com.antgroup.antchain.myjava.interop.DelegateTo;
import com.antgroup.antchain.myjava.interop.NoSideEffects;
import com.antgroup.antchain.myjava.interop.Structure;
import com.antgroup.antchain.myjava.runtime.Allocator;
import com.antgroup.antchain.myjava.runtime.RuntimeArray;
import com.antgroup.antchain.myjava.runtime.RuntimeClass;
import com.antgroup.antchain.myjava.runtime.RuntimeObject;
import com.antgroup.antchain.myjava.runtime.WasmArgValue;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;

public final class TArray
extends TObject {
    @PluggableDependency(value=ArrayNativeGenerator.class)
    @DelegateTo(value="getLengthLowLevel")
    @NoSideEffects
    public static native int getLength(TObject var0) throws TIllegalArgumentException;

    private static int getLengthLowLevel(RuntimeObject obj) {
        RuntimeClass cls = RuntimeClass.getClass((RuntimeObject)obj);
        if (cls.itemType == null) {
            throw new TIllegalArgumentException();
        }
        RuntimeArray array = (RuntimeArray)obj;
        return array.size;
    }

    public static TObject newInstance(Class<?> componentType, int length) throws TNegativeArraySizeException {
        if (componentType == null) {
            throw new TNullPointerException();
        }
        if (componentType == Void.TYPE) {
            throw new TIllegalArgumentException();
        }
        if (length < 0) {
            throw new TNegativeArraySizeException();
        }
        return (TObject)WasmRuntime.addressToObject((Address)TArray.newInstanceLowLevel((RuntimeClass)Address.ofObject(componentType).toStructure(), length));
    }

    private static Address newInstanceLowLevel(RuntimeClass cls, int length) {
        return Allocator.allocateArray((RuntimeClass)cls.arrayType, (int)length);
    }

    public static TObject get(TObject array, int index) throws TIllegalArgumentException, TArrayIndexOutOfBoundsException {
        if (index < 0 || index >= TArray.getLength(array)) {
            throw new TArrayIndexOutOfBoundsException();
        }
        return TArray.getImpl(array, index);
    }

    public static void set(TObject array, int index, TObject value) throws TIllegalArgumentException, TArrayIndexOutOfBoundsException {
        if (index < 0 || index >= TArray.getLength(array)) {
            throw new TArrayIndexOutOfBoundsException();
        }
        TArray.setImpl(array, index, value);
    }

    private static TObject getImpl(TObject array, int index) {
        if (Address.ofObject(array.getClass()).toInt() == Address.ofObject(double[].class).toInt()) {
            double[] doubleArray = (double[])WasmRuntime.addressToObject((Address)Address.ofObject((Object)array));
            Double doubleValue = doubleArray[index];
            return (TObject)WasmRuntime.addressToObject((Address)Address.ofObject((Object)doubleValue));
        }
        if (Address.ofObject(array.getClass()).toInt() == Address.ofObject(float[].class).toInt()) {
            float[] floatArray = (float[])WasmRuntime.addressToObject((Address)Address.ofObject((Object)array));
            Float floatValue = Float.valueOf(floatArray[index]);
            return (TObject)WasmRuntime.addressToObject((Address)Address.ofObject((Object)floatValue));
        }
        Address arrayAddr = Address.ofObject((Object)array);
        RuntimeClass cls = RuntimeClass.getClass((RuntimeObject)((RuntimeObject)Address.ofObject((Object)array).toStructure()));
        boolean isComponentTypePrimitive = (cls.itemType.flags & 2) != 0;
        int itemSize = isComponentTypePrimitive ? cls.itemType.size : Address.sizeOf();
        int headerSize = Address.align((Address)Address.fromInt((int)Structure.sizeOf(RuntimeArray.class)), (int)itemSize).toInt();
        Address itemAddressOffset = arrayAddr.add(headerSize).add(itemSize * index);
        Address itemAddress = itemAddressOffset.getAddress();
        long itemI64Value = 0L;
        if (isComponentTypePrimitive && ((Class)WasmRuntime.addressToObject((Address)cls.itemType.toAddress())).getName().equals("long")) {
            itemI64Value = itemAddressOffset.getLong();
        }
        if (isComponentTypePrimitive) {
            Object itemObjectValue = TMethod.maybePrimitiveValueWasmInt32ToObject(itemAddress.toInt(), itemI64Value, (TClass)WasmRuntime.addressToObject((Address)cls.itemType.toAddress()));
            return (TObject)itemObjectValue;
        }
        return (TObject)WasmRuntime.addressToObject((Address)itemAddress);
    }

    private static void setImpl(TObject array, int index, TObject value) {
        if (Address.ofObject(array.getClass()).toInt() == Address.ofObject(double[].class).toInt()) {
            double[] doubleArray = (double[])WasmRuntime.addressToObject((Address)Address.ofObject((Object)array));
            Double doubleValue = (Double)WasmRuntime.addressToObject((Address)Address.ofObject((Object)value));
            doubleArray[index] = doubleValue;
            return;
        }
        if (Address.ofObject(array.getClass()).toInt() == Address.ofObject(float[].class).toInt()) {
            float[] floatArray = (float[])WasmRuntime.addressToObject((Address)Address.ofObject((Object)array));
            Float floatValue = (Float)WasmRuntime.addressToObject((Address)Address.ofObject((Object)value));
            floatArray[index] = floatValue.floatValue();
            return;
        }
        Address arrayAddr = Address.ofObject((Object)array);
        RuntimeClass cls = RuntimeClass.getClass((RuntimeObject)((RuntimeObject)Address.ofObject((Object)array).toStructure()));
        boolean isComponentTypePrimitive = (cls.itemType.flags & 2) != 0;
        int itemSize = isComponentTypePrimitive ? cls.itemType.size : Address.sizeOf();
        int headerSize = Address.align((Address)Address.fromInt((int)Structure.sizeOf(RuntimeArray.class)), (int)itemSize).toInt();
        Address itemAddressOffset = arrayAddr.add(headerSize).add(itemSize * index);
        WasmArgValue valueAddressOrUnwrapped = TMethod.unwrapObjectToPrimitive(value, (TClass)WasmRuntime.addressToObject((Address)cls.itemType.toAddress()));
        if (isComponentTypePrimitive && ((Class)WasmRuntime.addressToObject((Address)cls.itemType.toAddress())).getName().equals("long")) {
            itemAddressOffset.putLong(valueAddressOrUnwrapped.i64);
            return;
        }
        itemAddressOffset.putAddress(Address.fromInt((int)valueAddressOrUnwrapped.i32));
    }
}

