/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.nio.charset;

import com.antgroup.antchain.myjava.classlib.java.nio.TByteBuffer;
import com.antgroup.antchain.myjava.classlib.java.nio.TCharBuffer;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCharacterCodingException;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCharsetDecoder;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCharsetEncoder;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCodingErrorAction;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TIllegalCharsetNameException;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TStandardCharsets;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TUnsupportedCharsetException;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@NoMetadata
public abstract class TCharset
implements Comparable<TCharset> {
    private String canonicalName;
    private String[] aliases;
    private Set<String> aliasSet;

    protected TCharset(String canonicalName, String[] aliases) {
        TCharset.checkCanonicalName(canonicalName);
        for (String alias : aliases) {
            TCharset.checkCanonicalName(alias);
        }
        this.canonicalName = canonicalName;
        this.aliases = (String[])aliases.clone();
    }

    private static void checkCanonicalName(String name) {
        if (name.isEmpty()) {
            throw new TIllegalCharsetNameException(name);
        }
        if (!TCharset.isValidCharsetStart(name.charAt(0))) {
            throw new TIllegalCharsetNameException(name);
        }
        block3: for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '+': 
                case '-': 
                case '.': 
                case ':': 
                case '_': {
                    continue block3;
                }
                default: {
                    if (TCharset.isValidCharsetStart(c)) continue block3;
                    throw new TIllegalCharsetNameException(name);
                }
            }
        }
    }

    private static boolean isValidCharsetStart(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static TCharset forName(String charsetName) {
        if (charsetName == null) {
            throw new IllegalArgumentException("charsetName is null");
        }
        TCharset.checkCanonicalName(charsetName);
        TCharset charset = (TCharset)Charsets.value.get(charsetName.toUpperCase());
        if (charset == null) {
            throw new TUnsupportedCharsetException(charsetName);
        }
        return charset;
    }

    public static TCharset defaultCharset() {
        return (TCharset)Charsets.value.get("UTF-8");
    }

    public final String name() {
        return this.canonicalName;
    }

    public final Set<String> aliases() {
        if (this.aliasSet == null) {
            this.aliasSet = new HashSet<String>();
            for (String alias : this.aliases) {
                this.aliasSet.add(alias);
            }
            this.aliasSet = Collections.unmodifiableSet(this.aliasSet);
        }
        return this.aliasSet;
    }

    public String displayName() {
        return this.canonicalName;
    }

    public abstract boolean contains(TCharset var1);

    public abstract TCharsetDecoder newDecoder();

    public abstract TCharsetEncoder newEncoder();

    public boolean canEncode() {
        return true;
    }

    public final TCharBuffer decode(TByteBuffer bb) {
        try {
            return this.newDecoder().onMalformedInput(TCodingErrorAction.REPLACE).onUnmappableCharacter(TCodingErrorAction.REPLACE).decode(bb);
        }
        catch (TCharacterCodingException e) {
            throw new AssertionError("Should never been thrown", e);
        }
    }

    public final TByteBuffer encode(TCharBuffer cb) {
        try {
            return this.newEncoder().onMalformedInput(TCodingErrorAction.REPLACE).onUnmappableCharacter(TCodingErrorAction.REPLACE).encode(cb);
        }
        catch (TCharacterCodingException e) {
            throw new AssertionError("Should never been thrown", e);
        }
    }

    public final TByteBuffer encode(String str) {
        return this.encode(TCharBuffer.wrap(str));
    }

    @Override
    public final int compareTo(TCharset that) {
        return this.canonicalName.compareToIgnoreCase(that.canonicalName);
    }

    @NoMetadata
    static class Charsets {
        private static final Map<String, TCharset> value;

        Charsets() {
        }

        static {
            TCharset[] charsets;
            value = new HashMap<String, TCharset>();
            for (TCharset charset : charsets = new TCharset[]{TStandardCharsets.UTF_8, TStandardCharsets.US_ASCII, TStandardCharsets.ISO_8859_1, TStandardCharsets.UTF_16, TStandardCharsets.UTF_16BE, TStandardCharsets.UTF_16LE}) {
                value.put(charset.name(), charset);
            }
        }
    }
}

