/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.text;

import com.antgroup.antchain.myjava.classlib.java.text.TFieldPosition;
import com.antgroup.antchain.myjava.classlib.java.text.TNumberFormat;
import com.antgroup.antchain.myjava.classlib.java.text.TParsePosition;
import com.antgroup.antchain.myjava.classlib.java.util.TLocale;
import java.util.ArrayList;
import java.util.Arrays;

public class TChoiceFormat
extends TNumberFormat {
    private double[] choiceLimits;
    private String[] choiceFormats;

    public TChoiceFormat(double[] limits, String[] formats) {
        this.setChoices(limits, formats);
    }

    public TChoiceFormat(String template) {
        this.applyPattern(template);
    }

    public void applyPattern(String template) {
        double[] limits = new double[5];
        ArrayList<String> formats = new ArrayList<String>();
        int length = template.length();
        int limitCount = 0;
        int index = 0;
        StringBuffer buffer = new StringBuffer();
        TNumberFormat format = TNumberFormat.getInstance(TLocale.US);
        TParsePosition position = new TParsePosition(0);
        while (true) {
            double next;
            if ((index = this.skipWhitespace(template, index)) >= length) {
                if (limitCount == limits.length) {
                    this.choiceLimits = limits;
                } else {
                    this.choiceLimits = new double[limitCount];
                    System.arraycopy(limits, 0, this.choiceLimits, 0, limitCount);
                }
                this.choiceFormats = new String[formats.size()];
                for (int i = 0; i < formats.size(); ++i) {
                    this.choiceFormats[i] = (String)formats.get(i);
                }
                return;
            }
            position.setIndex(index);
            Number value = format.parse(template, position);
            index = this.skipWhitespace(template, position.getIndex());
            if (position.getErrorIndex() != -1 || index >= length) {
                this.choiceLimits = new double[0];
                this.choiceFormats = new String[0];
                return;
            }
            char ch = template.charAt(index++);
            if (limitCount == limits.length) {
                double[] newLimits = new double[limitCount * 2];
                System.arraycopy(limits, 0, newLimits, 0, limitCount);
                limits = newLimits;
            }
            switch (ch) {
                case '#': 
                case '\u2264': {
                    next = value.doubleValue();
                    break;
                }
                case '<': {
                    next = TChoiceFormat.nextDouble(value.doubleValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (limitCount > 0 && next <= limits[limitCount - 1]) {
                throw new IllegalArgumentException();
            }
            buffer.setLength(0);
            position.setIndex(index);
            TChoiceFormat.upTo(template, position, buffer, '|');
            index = position.getIndex();
            limits[limitCount++] = next;
            formats.add(buffer.toString());
        }
    }

    @Override
    public Object clone() {
        TChoiceFormat clone = (TChoiceFormat)super.clone();
        clone.choiceLimits = (double[])this.choiceLimits.clone();
        clone.choiceFormats = (String[])this.choiceFormats.clone();
        return clone;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TChoiceFormat)) {
            return false;
        }
        TChoiceFormat choice = (TChoiceFormat)object;
        return Arrays.equals(this.choiceLimits, choice.choiceLimits) && Arrays.equals(this.choiceFormats, choice.choiceFormats);
    }

    @Override
    public StringBuffer format(double value, StringBuffer buffer, TFieldPosition field) {
        for (int i = this.choiceLimits.length - 1; i >= 0; --i) {
            if (!(this.choiceLimits[i] <= value)) continue;
            return buffer.append(this.choiceFormats[i]);
        }
        return this.choiceFormats.length == 0 ? buffer : buffer.append(this.choiceFormats[0]);
    }

    @Override
    public StringBuffer format(long value, StringBuffer buffer, TFieldPosition field) {
        return this.format((double)value, buffer, field);
    }

    public Object[] getFormats() {
        return this.choiceFormats;
    }

    public double[] getLimits() {
        return this.choiceLimits;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.choiceLimits.length; ++i) {
            long v = Double.doubleToLongBits(this.choiceLimits[i]);
            hashCode += (int)(v ^ v >>> 32) + this.choiceFormats[i].hashCode();
        }
        return hashCode;
    }

    public static double nextDouble(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return value;
        }
        long bits = value == 0.0 ? 0L : Double.doubleToLongBits(value);
        return Double.longBitsToDouble(value < 0.0 ? bits - 1L : bits + 1L);
    }

    public static double nextDouble(double value, boolean increment) {
        return increment ? TChoiceFormat.nextDouble(value) : TChoiceFormat.previousDouble(value);
    }

    @Override
    public Number parse(String string, TParsePosition position) {
        int offset = position.getIndex();
        for (int i = 0; i < this.choiceFormats.length; ++i) {
            if (!string.startsWith(this.choiceFormats[i], offset)) continue;
            position.setIndex(offset + this.choiceFormats[i].length());
            return this.choiceLimits[i];
        }
        position.setErrorIndex(offset);
        return Double.NaN;
    }

    public static double previousDouble(double value) {
        if (value == Double.NEGATIVE_INFINITY) {
            return value;
        }
        long bits = value == 0.0 ? Long.MIN_VALUE : Double.doubleToLongBits(value);
        return Double.longBitsToDouble(value <= 0.0 ? bits + 1L : bits - 1L);
    }

    public void setChoices(double[] limits, String[] formats) {
        if (limits.length != formats.length) {
            throw new IllegalArgumentException();
        }
        this.choiceLimits = limits;
        this.choiceFormats = formats;
    }

    private int skipWhitespace(String string, int index) {
        int length = string.length();
        while (index < length && Character.isWhitespace(string.charAt(index))) {
            ++index;
        }
        return index;
    }

    public String toPattern() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.choiceLimits.length; ++i) {
            boolean quote;
            if (i != 0) {
                buffer.append('|');
            }
            String previous = String.valueOf(TChoiceFormat.previousDouble(this.choiceLimits[i]));
            String limit = String.valueOf(this.choiceLimits[i]);
            if (previous.length() < limit.length()) {
                buffer.append(previous);
                buffer.append('<');
            } else {
                buffer.append(limit);
                buffer.append('#');
            }
            boolean bl = quote = this.choiceFormats[i].indexOf(124) != -1;
            if (quote) {
                buffer.append('\'');
            }
            buffer.append(this.choiceFormats[i]);
            if (!quote) continue;
            buffer.append('\'');
        }
        return buffer.toString();
    }
}

