/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.java.util.TCheckedCollection;
import com.antgroup.antchain.myjava.classlib.java.util.TCheckedSet;
import com.antgroup.antchain.myjava.classlib.java.util.TCollection;
import com.antgroup.antchain.myjava.classlib.java.util.THashMap;
import com.antgroup.antchain.myjava.classlib.java.util.TIterator;
import com.antgroup.antchain.myjava.classlib.java.util.TMap;
import com.antgroup.antchain.myjava.classlib.java.util.TSet;

class TCheckedMap<K, V>
implements TMap<K, V> {
    private TMap<K, V> innerMap;
    private Class<K> keyType;
    private Class<V> valueType;

    public TCheckedMap(TMap<K, V> innerMap, Class<K> keyType, Class<V> valueType) {
        this.innerMap = innerMap;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public int size() {
        return this.innerMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.innerMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.innerMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.innerMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.innerMap.put(this.keyType.cast(key), this.valueType.cast(value));
    }

    @Override
    public V remove(Object key) {
        return this.innerMap.remove(key);
    }

    @Override
    public void putAll(TMap<? extends K, ? extends V> m) {
        m = new THashMap<K, V>(m);
        TIterator iter = m.entrySet().iterator();
        while (iter.hasNext()) {
            TMap.Entry entry = (TMap.Entry)iter.next();
            this.keyType.cast(entry.getKey());
            this.valueType.cast(entry.getValue());
        }
        this.innerMap.putAll(m);
    }

    @Override
    public void clear() {
        this.innerMap.clear();
    }

    @Override
    public TSet<K> keySet() {
        return new TCheckedSet<K>(this.innerMap.keySet(), this.keyType);
    }

    @Override
    public TCollection<V> values() {
        return new TCheckedCollection<V>(this.innerMap.values(), this.valueType);
    }

    @Override
    public TSet<TMap.Entry<K, V>> entrySet() {
        return this.innerMap.entrySet();
    }
}

