/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.impl.tz.DateTimeZone;
import com.antgroup.antchain.myjava.classlib.java.util.TCalendar;
import com.antgroup.antchain.myjava.classlib.java.util.TDate;
import com.antgroup.antchain.myjava.classlib.java.util.TGregorianCalendar;
import com.antgroup.antchain.myjava.classlib.java.util.TTimeZone;
import java.util.Objects;

class TIANATimeZone
extends TTimeZone {
    private static final long serialVersionUID = -8196006595542230951L;
    private DateTimeZone underlyingZone;
    private int rawOffset;
    private int diff;

    public TIANATimeZone(DateTimeZone underlyingZone) {
        super(underlyingZone.getID());
        this.underlyingZone = underlyingZone;
        this.rawOffset = underlyingZone.getStandardOffset(System.currentTimeMillis());
        this.diff = -this.rawOffset;
    }

    @Override
    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int time) {
        TGregorianCalendar calendar = new TGregorianCalendar(year, month, day);
        calendar.set(0, era);
        calendar.set(7, dayOfWeek);
        ((TCalendar)calendar).add(14, time);
        return this.getOffset(calendar.getTimeInMillis());
    }

    @Override
    public int getOffset(long time) {
        return this.rawOffset + this.diff + this.underlyingZone.getOffset(time);
    }

    @Override
    public int getRawOffset() {
        return this.rawOffset;
    }

    @Override
    public boolean inDaylightTime(TDate time) {
        return this.underlyingZone.getOffset(time.getTime()) != this.underlyingZone.getStandardOffset(time.getTime());
    }

    @Override
    public void setRawOffset(int offset) {
        this.rawOffset = offset;
    }

    @Override
    public boolean useDaylightTime() {
        return !this.underlyingZone.isFixed();
    }

    @Override
    public TIANATimeZone clone() {
        TIANATimeZone copy = (TIANATimeZone)super.clone();
        copy.rawOffset = this.rawOffset;
        copy.underlyingZone = this.underlyingZone;
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TIANATimeZone)) {
            return false;
        }
        TIANATimeZone other = (TIANATimeZone)obj;
        return this.rawOffset == other.rawOffset && this.underlyingZone.getID().equals(other.getID());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rawOffset, this.underlyingZone.getID());
    }
}

