/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.concurrent;

import com.antgroup.antchain.myjava.interop.NoMetadata;

@NoMetadata
public enum TTimeUnit {
    NANOSECONDS(1L),
    MICROSECONDS(1000L),
    MILLISECONDS(1000000L),
    SECONDS(1000000000L),
    MINUTES(60000000000L),
    HOURS(3600000000000L),
    DAYS(86400000000000L);

    private long nanoseconds;

    private TTimeUnit(long nanoseconds) {
        this.nanoseconds = nanoseconds;
    }

    public long convert(long sourceDuration, TTimeUnit sourceUnit) {
        long sourceNanos = sourceUnit.nanoseconds;
        long targetNanos = this.nanoseconds;
        if (sourceNanos < targetNanos) {
            return sourceDuration / (targetNanos / sourceNanos);
        }
        return sourceDuration * (sourceNanos / targetNanos);
    }

    public long toNanos(long duration) {
        return duration * this.nanoseconds;
    }

    public long toMicros(long duration) {
        return MICROSECONDS.convert(duration, this);
    }

    public long toMillis(long duration) {
        return MILLISECONDS.convert(duration, this);
    }

    public long toSeconds(long duration) {
        return SECONDS.convert(duration, this);
    }

    public long toMinutes(long duration) {
        return MINUTES.convert(duration, this);
    }

    public long toHours(long duration) {
        return HOURS.convert(duration, this);
    }

    public long toDays(long duration) {
        return DAYS.convert(duration, this);
    }

    public void timedWait(Object obj, long timeout) throws InterruptedException {
        obj.wait(this.toMillis(timeout));
    }

    public void timedJoin(Thread thread, long timeout) throws InterruptedException {
        thread.join(this.toMillis(timeout));
    }

    public void sleep(long timeout) throws InterruptedException {
        Thread.sleep(this.toMillis(timeout));
    }
}

