/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.impl;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.ClassHolderTransformer;
import com.antgroup.antchain.myjava.model.ClassHolderTransformerContext;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;

public class SystemClassTransformer
implements ClassHolderTransformer {
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        for (MethodHolder method : cls.getMethods()) {
            if (method.getProgram() == null) continue;
            this.transformProgram(method.getProgram());
        }
    }

    private void transformProgram(Program program) {
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction insn : block) {
                GetFieldInstruction getField;
                FieldReference field;
                if (!(insn instanceof GetFieldInstruction) || !(field = (getField = (GetFieldInstruction)insn).getField()).getClassName().equals("java.lang.System")) continue;
                switch (field.getFieldName()) {
                    case "err": 
                    case "out": 
                    case "in": {
                        InvokeInstruction invoke = new InvokeInstruction();
                        invoke.setType(InvocationType.SPECIAL);
                        invoke.setMethod(new MethodReference("java.lang.System", field.getFieldName(), new ValueType[]{getField.getFieldType()}));
                        invoke.setReceiver(getField.getReceiver());
                        invoke.setLocation(insn.getLocation());
                        insn.replace((Instruction)invoke);
                        break;
                    }
                }
            }
        }
    }
}

