/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Formatter;
import java.util.Locale;
import java.util.Objects;

public class TPrintWriter
extends Writer {
    protected Writer out;
    private boolean ioError;
    private boolean autoflush;

    public TPrintWriter(OutputStream out) {
        this(new OutputStreamWriter(out), false);
    }

    public TPrintWriter(OutputStream out, boolean autoflush) {
        this(new OutputStreamWriter(out), autoflush);
    }

    public TPrintWriter(Writer wr) {
        this(wr, false);
    }

    public TPrintWriter(Writer wr, boolean autoflush) {
        super((Object)wr);
        this.autoflush = autoflush;
        this.out = wr;
    }

    public boolean checkError() {
        Writer delegate = this.out;
        if (delegate == null) {
            return this.ioError;
        }
        this.flush();
        return this.ioError;
    }

    @Override
    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                this.setError();
            }
            this.out = null;
        }
    }

    @Override
    public void flush() {
        if (this.out != null) {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                this.setError();
            }
        } else {
            this.setError();
        }
    }

    public TPrintWriter format(String format, Object ... args) {
        return this.format(Locale.getDefault(), format, args);
    }

    public TPrintWriter format(Locale l, String format, Object ... args) {
        Objects.requireNonNull(format);
        new Formatter(this, l).format(format, args);
        if (this.autoflush) {
            this.flush();
        }
        return this;
    }

    public TPrintWriter printf(String format, Object ... args) {
        return this.format(format, args);
    }

    public TPrintWriter printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    public void print(char[] charArray) {
        this.print(new String(charArray, 0, charArray.length));
    }

    public void print(char ch) {
        this.print(String.valueOf(ch));
    }

    public void print(double dnum) {
        this.print(String.valueOf(dnum));
    }

    public void print(float fnum) {
        this.print(String.valueOf(fnum));
    }

    public void print(int inum) {
        this.print(String.valueOf(inum));
    }

    public void print(long lnum) {
        this.print(String.valueOf(lnum));
    }

    public void print(Object obj) {
        this.print(String.valueOf(obj));
    }

    public void print(String str) {
        this.write(str != null ? str : String.valueOf(null));
    }

    public void print(boolean bool) {
        this.print(String.valueOf(bool));
    }

    public void println() {
        this.print("\n");
        if (this.autoflush) {
            this.flush();
        }
    }

    public void println(char[] charArray) {
        this.println(new String(charArray, 0, charArray.length));
    }

    public void println(char ch) {
        this.println(String.valueOf(ch));
    }

    public void println(double dnum) {
        this.println(String.valueOf(dnum));
    }

    public void println(float fnum) {
        this.println(String.valueOf(fnum));
    }

    public void println(int inum) {
        this.println(String.valueOf(inum));
    }

    public void println(long lnum) {
        this.println(String.valueOf(lnum));
    }

    public void println(Object obj) {
        this.println(String.valueOf(obj));
    }

    public void println(String str) {
        this.print(str);
        this.println();
    }

    public void println(boolean bool) {
        this.println(String.valueOf(bool));
    }

    protected void setError() {
        this.ioError = true;
    }

    @Override
    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(char[] buf, int offset, int count) {
        this.doWrite(buf, offset, count);
    }

    @Override
    public void write(int oneChar) {
        this.doWrite(new char[]{(char)oneChar}, 0, 1);
    }

    private void doWrite(char[] buf, int offset, int count) {
        if (this.out != null) {
            try {
                this.out.write(buf, offset, count);
            }
            catch (IOException e) {
                this.setError();
            }
        } else {
            this.setError();
        }
    }

    @Override
    public void write(String str) {
        this.write(str.toCharArray());
    }

    @Override
    public void write(String str, int offset, int count) {
        this.write(str.substring(offset, offset + count).toCharArray());
    }

    @Override
    public TPrintWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public TPrintWriter append(CharSequence csq) {
        if (null == csq) {
            this.append("null", 0, 4);
        } else {
            this.append(csq, 0, csq.length());
        }
        return this;
    }

    @Override
    public TPrintWriter append(CharSequence csq, int start, int end) {
        if (null == csq) {
            csq = "null";
        }
        String output = csq.subSequence(start, end).toString();
        this.write(output, 0, output.length());
        return this;
    }
}

