/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.lang;

import com.antgroup.antchain.myjava.classlib.java.io.TSerializable;
import com.antgroup.antchain.myjava.classlib.java.lang.TClass;
import com.antgroup.antchain.myjava.classlib.java.lang.TCloneNotSupportedException;
import com.antgroup.antchain.myjava.classlib.java.lang.TComparable;
import com.antgroup.antchain.myjava.classlib.java.lang.TIllegalArgumentException;
import com.antgroup.antchain.myjava.classlib.java.lang.TInteger;
import com.antgroup.antchain.myjava.classlib.java.lang.TObject;
import com.antgroup.antchain.myjava.classlib.java.lang.TString;
import com.antgroup.antchain.myjava.interop.Rename;

public abstract class TEnum<E extends TEnum<E>>
extends TObject
implements TComparable<E>,
TSerializable {
    private TString name;
    private int ordinal;

    protected TEnum(TString name, int ordinal) {
        this.name = name;
        this.ordinal = ordinal;
    }

    public void setEnumValue(TString name, int ordinal) {
        this.name = name;
        this.ordinal = ordinal;
    }

    public final TString name() {
        return this.name;
    }

    public final int ordinal() {
        return this.ordinal;
    }

    @Override
    public String toString() {
        return this.name.toString();
    }

    @Override
    public final boolean equals(Object other) {
        return this == other;
    }

    @Override
    public final int hashCode() {
        return Integer.valueOf(this.ordinal).hashCode();
    }

    @Rename(value="clone")
    protected final TObject clone0() throws TCloneNotSupportedException {
        throw new TCloneNotSupportedException();
    }

    public final TClass<E> getDeclaringClass() {
        Class<?> result = this.getClass();
        return (TClass)((Object)(result.getSuperclass().equals(Enum.class) ? result : result.getSuperclass()));
    }

    @Override
    public final int compareTo(E o) {
        if (((TEnum)o).getDeclaringClass() != this.getDeclaringClass()) {
            throw new TIllegalArgumentException("Can't compare " + this.getDeclaringClass() + " to " + ((TEnum)o).getDeclaringClass());
        }
        return TInteger.compare(this.ordinal, ((TEnum)o).ordinal());
    }

    public static <T extends TEnum<T>> T valueOf(TClass<T> enumType, TString name) {
        TEnum[] constants = (TEnum[])enumType.getEnumConstants();
        if (constants == null) {
            throw new TIllegalArgumentException("Class does not represent enum");
        }
        for (TEnum constant : constants) {
            if (!constant.name().equals(name)) continue;
            return (T)constant;
        }
        throw new TIllegalArgumentException("Enum " + enumType + " does not have the " + name + " constant");
    }
}

