/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.nio;

import com.antgroup.antchain.myjava.classlib.java.nio.TBufferOverflowException;
import com.antgroup.antchain.myjava.classlib.java.nio.TBufferUnderflowException;
import com.antgroup.antchain.myjava.classlib.java.nio.TLongBuffer;
import com.antgroup.antchain.myjava.classlib.java.nio.TReadOnlyBufferException;

abstract class TLongBufferImpl
extends TLongBuffer {
    private static void cpdBegin() {
    }

    public TLongBufferImpl(int capacity, int position, int limit) {
        super(capacity, position, limit);
    }

    @Override
    public TLongBuffer slice() {
        return this.duplicate(this.position, this.limit - this.position, 0, this.limit - this.position, this.isReadOnly());
    }

    @Override
    public TLongBuffer duplicate() {
        return this.duplicate(0, this.capacity, this.position, this.limit, this.isReadOnly());
    }

    @Override
    public TLongBuffer asReadOnlyBuffer() {
        return this.duplicate(0, this.capacity, this.position, this.limit, true);
    }

    abstract TLongBuffer duplicate(int var1, int var2, int var3, int var4, boolean var5);

    @Override
    public long get() {
        if (this.position >= this.limit) {
            throw new TBufferUnderflowException();
        }
        return this.getElement(this.position++);
    }

    @Override
    public TLongBuffer put(long b) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.position >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.putElement(this.position++, b);
        return this;
    }

    @Override
    public long get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + this.limit + ")");
        }
        return this.getElement(index);
    }

    @Override
    public TLongBuffer put(int index, long b) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + this.limit + ")");
        }
        this.putElement(index, b);
        return this;
    }

    @Override
    public TLongBuffer compact() {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        int sz = this.remaining();
        if (this.position > 0) {
            int src = this.position;
            for (int i = 0; i < sz; ++i) {
                this.putElement(i, this.getElement(src++));
            }
        }
        this.position = sz;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly();
    }

    abstract boolean readOnly();

    private static void cpdEnd() {
    }
}

