/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.java.lang.TIllegalStateException;
import com.antgroup.antchain.myjava.classlib.java.lang.TObject;
import com.antgroup.antchain.myjava.classlib.java.util.TAbstractCollection;
import com.antgroup.antchain.myjava.classlib.java.util.TAbstractSet;
import com.antgroup.antchain.myjava.classlib.java.util.TCollection;
import com.antgroup.antchain.myjava.classlib.java.util.TConcurrentModificationException;
import com.antgroup.antchain.myjava.classlib.java.util.THashMap;
import com.antgroup.antchain.myjava.classlib.java.util.TIterator;
import com.antgroup.antchain.myjava.classlib.java.util.TMap;
import com.antgroup.antchain.myjava.classlib.java.util.TNoSuchElementException;
import com.antgroup.antchain.myjava.classlib.java.util.TSet;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjava.interop.Rename;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@NoMetadata
public class TLinkedHashMap<K, V>
extends THashMap<K, V>
implements TMap<K, V> {
    private final boolean accessOrder;
    private transient LinkedHashMapEntry<K, V> head;
    private transient LinkedHashMapEntry<K, V> tail;

    public TLinkedHashMap() {
        this.accessOrder = false;
        this.head = null;
    }

    public TLinkedHashMap(int s) {
        super(s);
        this.accessOrder = false;
        this.head = null;
    }

    public TLinkedHashMap(int s, float lf) {
        super(s, lf);
        this.accessOrder = false;
        this.head = null;
        this.tail = null;
    }

    public TLinkedHashMap(int s, float lf, boolean order) {
        super(s, lf);
        this.accessOrder = order;
        this.head = null;
        this.tail = null;
    }

    public TLinkedHashMap(TMap<? extends K, ? extends V> m) {
        this.accessOrder = false;
        this.head = null;
        this.tail = null;
        this.putAll(m);
    }

    @Override
    public boolean containsValue(Object value) {
        LinkedHashMapEntry<K, V> entry = this.head;
        if (null == value) {
            while (null != entry) {
                if (null == entry.value) {
                    return true;
                }
                entry = entry.chainForward;
            }
        } else {
            while (null != entry) {
                if (value.equals(entry.value)) {
                    return true;
                }
                entry = entry.chainForward;
            }
        }
        return false;
    }

    @Override
    THashMap.HashEntry<K, V>[] newElementArray(int s) {
        return new LinkedHashMapEntry[s];
    }

    @Override
    public V get(Object key) {
        LinkedHashMapEntry m;
        if (key == null) {
            m = (LinkedHashMapEntry)this.findNullKeyEntry();
        } else {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
            m = (LinkedHashMapEntry)this.findNonNullKeyEntry(key, index, hash);
        }
        if (m == null) {
            return null;
        }
        if (this.accessOrder && this.tail != m) {
            LinkedHashMapEntry p = m.chainBackward;
            LinkedHashMapEntry n = m.chainForward;
            n.chainBackward = p;
            if (p != null) {
                p.chainForward = n;
            } else {
                this.head = n;
            }
            m.chainForward = null;
            m.chainBackward = this.tail;
            this.tail.chainForward = m;
            this.tail = m;
        }
        return (V)m.value;
    }

    @Override
    THashMap.HashEntry<K, V> createEntry(K key, int index, V value) {
        LinkedHashMapEntry<K, V> m = new LinkedHashMapEntry<K, V>(key, value);
        m.next = this.elementData[index];
        this.elementData[index] = m;
        this.linkEntry(m);
        return m;
    }

    @Override
    THashMap.HashEntry<K, V> createHashedEntry(K key, int index, int hash) {
        LinkedHashMapEntry m = new LinkedHashMapEntry(key, hash);
        m.next = this.elementData[index];
        this.elementData[index] = m;
        this.linkEntry(m);
        return m;
    }

    @Override
    public V put(K key, V value) {
        V result = this.putImpl(key, value);
        if (this.removeEldestEntry(this.head)) {
            this.remove(this.head.key);
        }
        return result;
    }

    @Override
    V putImpl(K key, V value) {
        LinkedHashMapEntry m;
        if (this.elementCount == 0) {
            this.head = null;
            this.tail = null;
        }
        if (key == null) {
            m = (LinkedHashMapEntry)this.findNullKeyEntry();
            if (m == null) {
                ++this.modCount;
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                }
                m = (LinkedHashMapEntry)this.createHashedEntry(null, 0, 0);
            } else {
                this.linkEntry(m);
            }
        } else {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
            m = (LinkedHashMapEntry)this.findNonNullKeyEntry(key, index, hash);
            if (m == null) {
                ++this.modCount;
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                    index = (hash & Integer.MAX_VALUE) % this.elementData.length;
                }
                m = (LinkedHashMapEntry)this.createHashedEntry(key, index, hash);
            } else {
                this.linkEntry(m);
            }
        }
        Object result = m.value;
        m.value = value;
        return (V)result;
    }

    void linkEntry(LinkedHashMapEntry<K, V> m) {
        if (this.tail == m) {
            return;
        }
        if (this.head == null) {
            this.head = m;
            this.tail = m;
            return;
        }
        LinkedHashMapEntry p = m.chainBackward;
        LinkedHashMapEntry n = m.chainForward;
        if (p == null) {
            if (n != null) {
                if (this.accessOrder) {
                    this.head = n;
                    n.chainBackward = null;
                    m.chainBackward = this.tail;
                    m.chainForward = null;
                    this.tail.chainForward = m;
                    this.tail = m;
                }
            } else {
                m.chainBackward = this.tail;
                m.chainForward = null;
                this.tail.chainForward = m;
                this.tail = m;
            }
            return;
        }
        if (n == null) {
            return;
        }
        if (this.accessOrder) {
            p.chainForward = n;
            n.chainBackward = p;
            m.chainForward = null;
            m.chainBackward = this.tail;
            this.tail.chainForward = m;
            this.tail = m;
        }
    }

    @Override
    public TSet<TMap.Entry<K, V>> entrySet() {
        return new LinkedHashMapEntrySet(this);
    }

    @Override
    public TSet<K> keySet() {
        if (this.cachedKeySet == null) {
            this.cachedKeySet = new TAbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return TLinkedHashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return TLinkedHashMap.this.size();
                }

                @Override
                public void clear() {
                    TLinkedHashMap.this.clear();
                }

                @Override
                public boolean remove(Object key) {
                    if (TLinkedHashMap.this.containsKey(key)) {
                        TLinkedHashMap.this.remove(key);
                        return true;
                    }
                    return false;
                }

                @Override
                public TIterator<K> iterator() {
                    return new KeyIterator(TLinkedHashMap.this);
                }

                @Override
                public void forEach(Consumer<? super K> action) {
                    if (TLinkedHashMap.this.elementCount > 0) {
                        int prevModCount = TLinkedHashMap.this.modCount;
                        LinkedHashMapEntry entry = TLinkedHashMap.this.head;
                        do {
                            action.accept(entry.key);
                            entry = entry.chainForward;
                            if (TLinkedHashMap.this.modCount == prevModCount) continue;
                            throw new TConcurrentModificationException();
                        } while (entry != null);
                    }
                }
            };
        }
        return this.cachedKeySet;
    }

    @Override
    public TCollection<V> values() {
        if (this.cachedValues == null) {
            this.cachedValues = new TAbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return TLinkedHashMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return TLinkedHashMap.this.size();
                }

                @Override
                public void clear() {
                    TLinkedHashMap.this.clear();
                }

                @Override
                public TIterator<V> iterator() {
                    return new ValueIterator(TLinkedHashMap.this);
                }

                @Override
                public void forEach(Consumer<? super V> action) {
                    if (TLinkedHashMap.this.elementCount > 0) {
                        int prevModCount = TLinkedHashMap.this.modCount;
                        LinkedHashMapEntry entry = TLinkedHashMap.this.head;
                        do {
                            action.accept(entry.value);
                            entry = entry.chainForward;
                            if (TLinkedHashMap.this.modCount == prevModCount) continue;
                            throw new TConcurrentModificationException();
                        } while (entry != null);
                    }
                }
            };
        }
        return this.cachedValues;
    }

    @Override
    public V remove(Object key) {
        LinkedHashMapEntry m = (LinkedHashMapEntry)this.removeEntry(key);
        if (m == null) {
            return null;
        }
        LinkedHashMapEntry p = m.chainBackward;
        LinkedHashMapEntry n = m.chainForward;
        if (p != null) {
            p.chainForward = n;
        } else {
            this.head = n;
        }
        if (n != null) {
            n.chainBackward = p;
        } else {
            this.tail = p;
        }
        return (V)m.value;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (this.elementCount > 0) {
            int prevModCount = this.modCount;
            LinkedHashMapEntry<K, V> entry = this.head;
            do {
                action.accept(entry.key, entry.value);
                entry = entry.chainForward;
                if (this.modCount == prevModCount) continue;
                throw new TConcurrentModificationException();
            } while (entry != null);
        }
    }

    protected boolean removeEldestEntry(TMap.Entry<K, V> eldest) {
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.head = null;
        this.tail = null;
    }

    @Override
    @Rename(value="clone")
    public TObject clone0() {
        return (TObject)super.clone();
    }

    static final class LinkedHashMapEntry<K, V>
    extends THashMap.HashEntry<K, V> {
        LinkedHashMapEntry<K, V> chainForward = null;
        LinkedHashMapEntry<K, V> chainBackward = null;

        LinkedHashMapEntry(K theKey, V theValue) {
            super(theKey, theValue);
        }

        LinkedHashMapEntry(K theKey, int hash) {
            super(theKey, hash);
        }

        @Override
        public Object clone() {
            LinkedHashMapEntry entry = (LinkedHashMapEntry)super.clone();
            entry.chainBackward = this.chainBackward;
            entry.chainForward = this.chainForward;
            LinkedHashMapEntry lnext = (LinkedHashMapEntry)entry.next;
            if (lnext != null) {
                entry.next = (LinkedHashMapEntry)lnext.clone();
            }
            return entry;
        }
    }

    static final class LinkedHashMapEntrySet<K, V>
    extends THashMap.HashMapEntrySet<K, V> {
        public LinkedHashMapEntrySet(TLinkedHashMap<K, V> lhm) {
            super(lhm);
        }

        @Override
        public TIterator<TMap.Entry<K, V>> iterator() {
            return new EntryIterator((TLinkedHashMap)this.hashMap());
        }

        @Override
        public void forEach(Consumer<? super TMap.Entry<K, V>> action) {
            TLinkedHashMap map = (TLinkedHashMap)this.hashMap();
            if (map.elementCount > 0) {
                int prevModCount = map.modCount;
                LinkedHashMapEntry entry = map.head;
                do {
                    action.accept(entry);
                    entry = entry.chainForward;
                    if (map.modCount == prevModCount) continue;
                    throw new TConcurrentModificationException();
                } while (entry != null);
            }
        }
    }

    private static class ValueIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements TIterator<V> {
        ValueIterator(TLinkedHashMap<K, V> map) {
            super(map);
        }

        @Override
        public V next() {
            this.makeNext();
            return (V)this.currentEntry.value;
        }
    }

    private static class KeyIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements TIterator<K> {
        KeyIterator(TLinkedHashMap<K, V> map) {
            super(map);
        }

        @Override
        public K next() {
            this.makeNext();
            return (K)this.currentEntry.key;
        }
    }

    private static class EntryIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements TIterator<TMap.Entry<K, V>> {
        EntryIterator(TLinkedHashMap<K, V> map) {
            super(map);
        }

        @Override
        public TMap.Entry<K, V> next() {
            this.makeNext();
            return this.currentEntry;
        }
    }

    @NoMetadata
    private static class AbstractMapIterator<K, V> {
        int expectedModCount;
        LinkedHashMapEntry<K, V> futureEntry;
        LinkedHashMapEntry<K, V> currentEntry;
        final TLinkedHashMap<K, V> associatedMap;

        AbstractMapIterator(TLinkedHashMap<K, V> map) {
            this.expectedModCount = map.modCount;
            this.futureEntry = ((TLinkedHashMap)map).head;
            this.associatedMap = map;
        }

        public boolean hasNext() {
            return this.futureEntry != null;
        }

        final void checkConcurrentMod() throws TConcurrentModificationException {
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new TConcurrentModificationException();
            }
        }

        final void makeNext() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new TNoSuchElementException();
            }
            this.currentEntry = this.futureEntry;
            this.futureEntry = this.futureEntry.chainForward;
        }

        public void remove() {
            this.checkConcurrentMod();
            if (this.currentEntry == null) {
                throw new TIllegalStateException();
            }
            this.associatedMap.removeEntry(this.currentEntry);
            LinkedHashMapEntry<K, V> lhme = this.currentEntry;
            LinkedHashMapEntry p = lhme.chainBackward;
            LinkedHashMapEntry n = lhme.chainForward;
            TLinkedHashMap<K, V> lhm = this.associatedMap;
            if (p != null) {
                p.chainForward = n;
                if (n != null) {
                    n.chainBackward = p;
                } else {
                    ((TLinkedHashMap)lhm).tail = p;
                }
            } else {
                ((TLinkedHashMap)lhm).head = n;
                if (n != null) {
                    n.chainBackward = null;
                } else {
                    ((TLinkedHashMap)lhm).tail = null;
                }
            }
            this.currentEntry = null;
            ++this.expectedModCount;
        }
    }
}

