/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.java.lang.TIllegalStateException;
import com.antgroup.antchain.myjava.classlib.java.lang.TObject;
import com.antgroup.antchain.myjava.classlib.java.util.THashSet;
import com.antgroup.antchain.myjava.classlib.java.util.TSet;
import com.antgroup.antchain.myjava.classlib.java.util.TTimerTask;
import java.util.Date;
import java.util.Objects;

public class TTimer
extends TObject {
    TSet<TTimerTask> tasks = new THashSet<TTimerTask>();
    private volatile boolean cancelled;
    private String threadName;
    private boolean daemon;

    public TTimer() {
    }

    public TTimer(String name) {
        Objects.requireNonNull(name);
        this.threadName = name;
    }

    public TTimer(boolean daemon) {
        this.daemon = daemon;
    }

    public TTimer(String name, boolean daemon) {
        Objects.requireNonNull(name);
        this.threadName = name;
        this.daemon = daemon;
    }

    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        for (TTimerTask task : this.tasks.toArray(new TTimerTask[0])) {
            task.cancel();
        }
    }

    public void schedule(TTimerTask task, Date time) {
        long delay = Math.max(0L, time.getTime() - System.currentTimeMillis());
        this.schedule(task, delay);
    }

    public void schedule(TTimerTask task, long delay) {
    }

    public void schedule(TTimerTask task, Date time, long period) {
        long delay = Math.max(0L, time.getTime() - System.currentTimeMillis());
        this.schedule(task, delay, period);
    }

    public void schedule(TTimerTask task, long delay, long period) {
        if (this.cancelled || task.timer != null || task.nativeTimerId >= 0) {
            throw new TIllegalStateException();
        }
        task.timer = this;
    }

    public void scheduleAtFixedRate(TTimerTask task, Date time, long period) {
        long delay = Math.max(0L, time.getTime() - System.currentTimeMillis());
        this.scheduleAtFixedRate(task, delay, period);
    }

    public void scheduleAtFixedRate(TTimerTask task, long delay, long period) {
        if (this.cancelled || task.timer != null || task.nativeTimerId >= 0) {
            throw new TIllegalStateException();
        }
        long[] nextStartTime = new long[]{System.currentTimeMillis() + delay};
        task.timer = this;
        nextStartTime[0] = nextStartTime[0] + period;
    }

    private void runThread(Thread thread) {
        if (this.threadName != null) {
            thread.setName(this.threadName);
            thread.setDaemon(this.daemon);
        }
        thread.start();
    }
}

